/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyContextUtil {
    @Nullable
    public static JSType getTypeWithAppliedContext(@NotNull JSType type, @NotNull JSEvaluateContext context) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSApplyContextUtil.$$$reportNull$$$0(1);
        }
        if (context.isJSElementsToApplyEmpty()) {
            return type;
        }
        JSApplyContextElement pop = context.popJSElementToApply();
        JSType result2 = null;
        if (pop instanceof JSApplyCallElement) {
            JSType innerType;
            if (type instanceof JSFunctionTypeImpl && (innerType = ((JSFunctionTypeImpl)type).getReturnType()) != null) {
                result2 = JSApplyContextUtil.getTypeWithAppliedContext(innerType, context);
            }
        } else if (pop instanceof JSApplyPropertyElement) {
            if (type instanceof JSRecordType) {
                JSType propertyType;
                JSRecordType.PropertySignature signature = ((JSRecordType)type).findPropertySignature(((JSApplyPropertyElement)pop).getName());
                JSType jSType = propertyType = signature != null ? signature.getType() : null;
                if (propertyType != null) {
                    result2 = JSApplyContextUtil.getTypeWithAppliedContext(propertyType, context);
                }
            }
        } else if (pop instanceof JSApplyIndexedAccessElement) {
            Ref componentType = Ref.create();
            JSApplyContextUtil.processDestructuringArray((JSApplyIndexedAccessElement)pop, type, arg_0 -> ((Ref)componentType).set(arg_0));
            if (!componentType.isNull()) {
                result2 = JSApplyContextUtil.getTypeWithAppliedContext((JSType)componentType.get(), context);
            }
        }
        context.pushJSElementToApply(pop);
        return result2;
    }

    public static void processDestructuringArray(@NotNull JSApplyIndexedAccessElement pop, @NotNull JSType _type, @NotNull java.util.function.Consumer<JSType> callback) {
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(2);
        }
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(4);
        }
        JSDestructuringArray destructuringArray = pop.getDestructuringArray();
        PsiElement arrayElement = pop.getArrayElement();
        JSDestructuringArrayRestElement restElement = destructuringArray.getRestElement();
        if (_type instanceof JSTupleTypeImpl) {
            JSType newType;
            JSTupleTypeImpl tupleType = (JSTupleTypeImpl)_type;
            int indexMatched = ArrayUtil.indexOf((Object[])destructuringArray.getElements(), (Object)arrayElement);
            JSType toProcess = tupleType.getTypeByIndex(indexMatched);
            if (toProcess != null) {
                callback.accept(toProcess);
                return;
            }
            if (restElement != null && arrayElement == restElement && (newType = tupleType.excludePrefix(destructuringArray.getElements().length)) != null) {
                callback.accept(newType);
                return;
            }
        }
        if (restElement != null && arrayElement == restElement) {
            callback.accept(_type);
            return;
        }
        JSType componentType = JSTypeUtils.getIndexableComponentType(_type);
        if (componentType != null) {
            JSType optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(componentType);
            if (optimizeTypeIfComposite instanceof JSCompositeTypeImpl) {
                optimizeTypeIfComposite = JSTypeUtils.copyWithStrict(optimizeTypeIfComposite, false);
            }
            callback.accept(optimizeTypeIfComposite);
        }
    }

    public static void applyTypeToContext(@NotNull JSType type, @Nullable JSEvaluationResultContext evaluateContext, @NotNull BiConsumer<JSType, JSEvaluationResultContext> consumer) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JSApplyContextUtil.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            consumer.accept(type, null);
            return;
        }
        JSApplyCallElement newElement = null;
        JSType baseType = null;
        if (type instanceof JSApplyCallType) {
            baseType = ((JSApplyCallType)type).getBaseType();
            newElement = JSApplyCallElement.EMPTY;
        }
        if (newElement == null) {
            consumer.accept(type, evaluateContext);
            return;
        }
        JSType _baseType = baseType;
        JSEvaluateContext.processWithJSElementToApply(newElement, evaluateContext, (Consumer<JSEvaluationResultContext>)((Consumer)newContext -> {
            if (consumer == null) {
                JSApplyContextUtil.$$$reportNull$$$0(15);
            }
            consumer.accept(_baseType, (JSEvaluationResultContext)newContext);
        }));
    }

    public static void processDestructuringProperty(@NotNull JSApplyPropertyElement pop, @NotNull JSType _type, @NotNull BiConsumer<JSType, PsiElement> callback) {
        String propertyName;
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(7);
        }
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(9);
        }
        _type = JSTypeUtils.getValuableType(_type);
        JSDestructuringProperty property = pop.getProperty();
        if (!(_type instanceof JSRecordType) && DialectDetector.isTypeScript((PsiElement)property)) {
            _type = _type.asRecordType();
        }
        if (property.isRest()) {
            JSDestructuringObject objectPattern = (JSDestructuringObject)ObjectUtils.tryCast((Object)property.getParent(), JSDestructuringObject.class);
            if (objectPattern == null) {
                return;
            }
            Set existingNames = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), p -> !p.isRest() ? p.getName() : null);
            if (_type instanceof JSRecordType) {
                JSTypeSource jsTypeSource = JSTypeSourceFactory.copyTypeSource(_type.getSource(), (PsiElement)property);
                List typeMembers = ContainerUtil.filter((Collection)((JSRecordType)_type).getTypeMembers(), p -> p instanceof JSRecordType.PropertySignature && !existingNames.contains(((JSRecordType.PropertySignature)p).getMemberName()));
                JSRecordTypeImpl type = new JSRecordTypeImpl(jsTypeSource, typeMembers);
                callback.accept(type, (PsiElement)property);
            }
        }
        if (StringUtil.isEmpty((String)(propertyName = property.getName()))) {
            return;
        }
        if (_type instanceof JSRecordType) {
            JSApplyContextUtil.processRecordTypeDestructuringProperty((JSRecordType)_type, callback, propertyName);
        } else if (_type instanceof JSNamedType) {
            String newTypeName = _type.getTypeText(JSType.TypeTextFormat.RESOLVED) + "." + propertyName;
            JSTypeSource newTypeSource = JSTypeSourceFactory.copyTypeSource(_type.getSource(), (PsiElement)property);
            JSType newType = JSNamedType.createType(newTypeName, newTypeSource, JSContext.STATIC);
            callback.accept(newType, (PsiElement)property);
        }
    }

    private static void processRecordTypeDestructuringProperty(@NotNull JSRecordType _type, @NotNull BiConsumer<JSType, PsiElement> callback, @NotNull String propertyName) {
        JSRecordType.PropertySignature signature;
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(11);
        }
        if (propertyName == null) {
            JSApplyContextUtil.$$$reportNull$$$0(12);
        }
        if ((signature = _type.findPropertySignature(propertyName)) != null) {
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)signature, signature.getType());
            return;
        }
        JSRecordType.IndexSignature numericIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
        if (numericIndexer != null && JSNumberParser.tryParseNumericValue(propertyName, false) != null) {
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)numericIndexer, numericIndexer.getMemberType());
            return;
        }
        JSRecordType.IndexSignature stringIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        if (stringIndexer != null) {
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)stringIndexer, stringIndexer.getMemberType());
        }
    }

    private static void acceptMemberType(@NotNull BiConsumer<JSType, PsiElement> callback, @NotNull JSRecordType.TypeMember member, @Nullable JSType propertyType) {
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(13);
        }
        if (member == null) {
            JSApplyContextUtil.$$$reportNull$$$0(14);
        }
        if (propertyType == null) {
            return;
        }
        JSRecordType.MemberSource source = member.getMemberSource();
        List elements = source.getAllSourceElements();
        if (elements.size() == 0) {
            callback.accept(propertyType, null);
            return;
        }
        for (PsiElement e : elements) {
            callback.accept(propertyType, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pop";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeWithAppliedContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDestructuringArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTypeToContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processDestructuringProperty";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processRecordTypeDestructuringProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptMemberType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$applyTypeToContext$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

