/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericParameterImpl
extends JSTypeBaseImpl {
    @NotNull
    private final String myName;
    @Nullable
    private final JSType myConstraintType;
    private final boolean isCallEnvironment;

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source) {
        if (name == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(0);
        }
        this(name, source, null);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType) {
        if (name == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(1);
        }
        this(name, source, constraintType, false);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType, boolean env) {
        if (name == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myName = name;
        this.myConstraintType = constraintType;
        this.isCallEnvironment = env;
    }

    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType;
    }

    public boolean isCallEnvironment() {
        return this.isCallEnvironment;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericParameter((JSType)this);
    }

    @NotNull
    protected JSGenericParameterImpl createNewParameter(JSType newConstraint) {
        JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.getName(), this.getSource(), newConstraint, this.isCallEnvironment);
        if (jSGenericParameterImpl == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(3);
        }
        return jSGenericParameterImpl;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = format == JSType.TypeTextFormat.SERIALIZED ? '%' + this.myName + '%' : this.myName;
        if (string == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.myName, JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.myConstraintType));
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean isJavaScriptContext;
        if (elementType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(5);
        }
        if (this.myConstraintType == null) {
            return true;
        }
        boolean currentCallEnv = this.isCallEnvironment || JSGenericParameterImpl.isCallEnvironment(processingContext);
        boolean bl = isJavaScriptContext = !this.isTypeScript() || !elementType.getSource().isTypeScript();
        if (this.myConstraintType != null && (currentCallEnv || isJavaScriptContext)) {
            return this.myConstraintType.isDirectlyAssignableType(elementType, processingContext);
        }
        return currentCallEnv || this.isEquivalentTo(elementType, processingContext);
    }

    public static boolean isCallEnvironment(@Nullable ProcessingContext processingContext) {
        return processingContext != null && Boolean.TRUE.equals(processingContext.get(CALL_ENV_KEY));
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(7);
        }
        if (!allowResolve) {
            return false;
        }
        if (type instanceof JSGenericParameterImpl) {
            if (!this.myName.equals(((JSGenericParameterImpl)type).myName)) {
                return false;
            }
            JSType secondConstraintType = ((JSGenericParameterImpl)type).myConstraintType;
            if (this.myConstraintType == secondConstraintType) {
                return true;
            }
            if (this.myConstraintType == null || secondConstraintType == null) {
                return false;
            }
            return this.myConstraintType.isEquivalentTo(secondConstraintType, processingContext);
        }
        return false;
    }

    public static JSGenericParameterImpl cloneWithEnvironment(JSGenericParameterImpl type, boolean isMethodCall) {
        return new JSGenericParameterImpl(type.myName, type.getSource(), type.myConstraintType, isMethodCall);
    }

    @Override
    protected final boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return false;
    }

    @Override
    @NotNull
    protected JSGenericParameterImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(8);
        }
        JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.getTypeText(), source, this.getConstraintType());
        if (jSGenericParameterImpl == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(9);
        }
        return jSGenericParameterImpl;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(10);
        }
        JSGenericParameterImpl jSGenericParameterImpl = this;
        if (jSGenericParameterImpl == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(11);
        }
        return jSGenericParameterImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

