/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    public static final String SEPARATOR = "&";

    @NotNull
    public static JSType getIntersectionType(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        LinkedHashSet plainTypes = ContainerUtil.newLinkedHashSet();
        JSIntersectionTypeImpl.addTypesOverIntersection(types, plainTypes);
        JSType simplifiedType = JSIntersectionTypeImpl.getSimplifiedTypeIfPossible(plainTypes, source, false, true);
        if (simplifiedType != null) {
            JSType jSType = simplifiedType;
            if (jSType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        JSIntersectionTypeImpl jSIntersectionTypeImpl = new JSIntersectionTypeImpl(source, plainTypes);
        if (jSIntersectionTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        return jSIntersectionTypeImpl;
    }

    @Nullable
    protected static JSType getSimplifiedTypeIfPossible(@NotNull Collection<JSType> plainTypes, JSTypeSource source, boolean allowResolve, boolean intersection) {
        if (plainTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        int i = -1;
        if (intersection) {
            for (JSType type : plainTypes) {
                ++i;
                if (allowResolve) {
                    if (type instanceof JSTypeImpl) {
                        JSType typedef = ((JSTypeImpl)type).getTypedef();
                        type = typedef != null ? typedef : type;
                    }
                    type = JSTypeUtils.getValuableType(type);
                }
                if (!(type instanceof JSCompositeTypeImpl)) continue;
                List<JSType> parts = ((JSCompositeTypeImpl)type).getTypes();
                ArrayList newParts = ContainerUtil.newArrayListWithCapacity((int)parts.size());
                for (int j = 0; j < parts.size(); ++j) {
                    ArrayList typesCopy = ContainerUtil.newArrayListWithCapacity((int)plainTypes.size());
                    typesCopy.addAll(plainTypes);
                    typesCopy.set(i, parts.get(j));
                    newParts.add(j, JSIntersectionTypeImpl.getIntersectionType(typesCopy, source));
                }
                return new JSCompositeTypeImpl(source, newParts);
            }
        }
        if (plainTypes.size() == 0) {
            return JSAnyType.get(null, false);
        }
        if (plainTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(plainTypes);
        }
        if (intersection && JSIntersectionTypeImpl.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem(plainTypes);
            assert (item != null);
            return JSAnyType.get(null, true);
        }
        return null;
    }

    public static boolean hasAnyType(@NotNull Collection<JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(5);
        }
        for (JSType type : types) {
            if (!(type instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    protected static void addTypesOverIntersection(@Nullable Collection<JSType> typesToAdd, @NotNull Collection<JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        if (typesToAdd == null) {
            return;
        }
        for (JSType type : typesToAdd) {
            if (type instanceof JSIntersectionTypeImpl) {
                JSIntersectionTypeImpl.addTypesOverIntersection(((JSIntersectionTypeImpl)type).getTypes(), types);
                continue;
            }
            types.add(type);
        }
    }

    public JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<JSType> _types) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        if (_types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(8);
        }
        super(source, _types);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(9);
        }
        if (!JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        boolean allAssignable = true;
        for (JSType type : this.getTypes()) {
            if (type.isDirectlyAssignableType(elementType, processingContext)) continue;
            allAssignable = false;
            break;
        }
        if (allAssignable) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if (SEPARATOR == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(10);
        }
        return SEPARATOR;
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(11);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(12);
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(transformedTypes, newSource);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType substituteCompositeImpl() {
        JSType result2 = this.getSimpleCompositeTypeResult();
        if (result2 != null) {
            JSType jSType = result2;
            if (jSType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
            if (jSAnyType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(15);
            }
            return jSAnyType;
        }
        ArrayList resultMembers = ContainerUtil.newArrayList();
        LinkedMultiMap map = new LinkedMultiMap();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    Object signatures;
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    String name = propertySignature.getMemberName();
                    if (map.containsKey((Object)name) && (signatures = map.get((Object)name)).stream().anyMatch(s -> JSIntersectionTypeImpl.signaturesAreSkippablyEquivalent(propertySignature, s))) continue;
                    map.putValue((Object)name, (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                boolean isOptional = true;
                ArrayList types = ContainerUtil.newArrayList();
                ArrayList propertySources = ContainerUtil.newArrayListWithCapacity((int)value.size());
                for (JSRecordType.PropertySignature signature : value) {
                    if (!signature.isOptional()) {
                        isOptional = false;
                    }
                    if (signature.getType() != null) {
                        types.add(signature.getType());
                    }
                    JSRecordType.MemberSource source = signature.getMemberSource();
                    propertySources.addAll(source.getAllSourceElements());
                }
                JSType resultType = JSIntersectionTypeImpl.getIntersectionType(types, this.getSource());
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, isOptional, JSRecordMemberSourceFactory.createSource(propertySources, JSRecordType.MemberSourceKind.Intersection)));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(16);
        }
        return jSRecordTypeImpl;
    }

    private static boolean signaturesAreSkippablyEquivalent(JSRecordType.PropertySignature propertySignature, JSRecordType.PropertySignature s) {
        if (!s.isEquivalentTo((JSRecordType.TypeMember)propertySignature, true)) {
            return false;
        }
        JSRecordType.MemberSource memberSource = s.getMemberSource();
        JSRecordType.MemberSource otherSource = propertySignature.getMemberSource();
        if (memberSource.getMemberSourceKind() != JSRecordType.MemberSourceKind.Identity || otherSource.getMemberSourceKind() != JSRecordType.MemberSourceKind.Identity) {
            return false;
        }
        return memberSource.getSingleElement() == otherSource.getSingleElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompositeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionType";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifiedTypeIfPossible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTypesOverIntersection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

