/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLocalNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedTypeFactory {
    static final char QUOTE_ESCAPE_MARK = 'q';
    static final String QUOTE_ESCAPE = '^' + Character.toString('q');
    static final String STATIC_SUFFIX = "^s";
    private static final String PROTOTYPE_SUFFIX = ".prototype";
    private static final String PROTOTYPE_CONSTRUCTOR_SUFFIX = ".prototype.constructor";
    static final String FUNCTION_TYPE_SUFFIX = "^f";
    static final String WIDENED_SUFFIX = "^w";

    @NotNull
    public static JSType createExplicitlyDeclaredType(@NotNull String typeString, @Nullable PsiElement element) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(0);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource(element, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSContext staticOrInstance) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(3);
        }
        if (staticOrInstance == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(4);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeString, source, JSTypeContext.fromJSContext(staticOrInstance));
        if (jSType == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(6);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(7);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(8);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeString, source, typeContext, true);
        if (jSType == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext, boolean isFromJSDoc) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(10);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(11);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(12);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeString, source, typeContext, isFromJSDoc, false);
        if (jSType == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext, boolean isFromJSDoc, boolean inheritsFunction) {
        JSType primitiveType;
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(14);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(15);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(16);
        }
        PsiFile scope = source.getScope();
        if ("*".equals(typeString) || source.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(typeString)) {
            JSAnyType jSAnyType = JSAnyType.get((PsiElement)scope, true);
            if (jSAnyType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(17);
            }
            return jSAnyType;
        }
        if (scope != null && scope != scope.getOriginalFile()) {
            source = new JSTypeSource(scope.getOriginalFile(), source.getSourceElement(), source.getLanguage(), source.isStrict(), source.isExplicitlyDeclared());
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.AS) {
            JSType genericArgument = null;
            if ("Vector$object".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Object", source, JSContext.INSTANCE);
            }
            if ("Vector$int".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("int", source, JSContext.INSTANCE);
            }
            if ("Vector$uint".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("uint", source, JSContext.INSTANCE);
            }
            if ("Vector$double".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Number", source, JSContext.INSTANCE);
            }
            if (genericArgument != null) {
                JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedTypeFactory.createType("Vector", source, typeContext), genericArgument);
                if (jSGenericTypeImpl == null) {
                    JSNamedTypeFactory.$$$reportNull$$$0(18);
                }
                return jSGenericTypeImpl;
            }
        }
        boolean isWidened = false;
        if ((typeString = StringUtil.replace((String)typeString, (String)QUOTE_ESCAPE, (String)"\"")).endsWith(WIDENED_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - WIDENED_SUFFIX.length());
            isWidened = true;
        }
        if (typeString.endsWith(FUNCTION_TYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - FUNCTION_TYPE_SUFFIX.length());
            inheritsFunction = true;
        }
        if (typeString.endsWith(STATIC_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - STATIC_SUFFIX.length());
            typeContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith(PROTOTYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_SUFFIX.length());
            typeContext = JSTypeContext.PROTOTYPE;
        } else if (typeString.endsWith(PROTOTYPE_CONSTRUCTOR_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_CONSTRUCTOR_SUFFIX.length());
            typeContext = JSTypeContext.STATIC;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.JS && source.getSourceElement() instanceof JSFunctionItem && typeContext != JSTypeContext.INSTANCE) {
            inheritsFunction = true;
        }
        Object object = (primitiveType = JSSpecialNamedTypeImpl.getSpecialType(typeString, source, typeContext, isFromJSDoc)) != null ? primitiveType : new JSTypeImpl(typeString, source, typeContext, inheritsFunction, isWidened);
        if (object == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(19);
        }
        return object;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(20);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, null);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(21);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(22);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, false);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(23);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(24);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, true);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(25);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(26);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, isDeclaration, false);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(27);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration, boolean isLocal) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(28);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, isDeclaration, isLocal, false);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(29);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration, boolean isLocal, boolean inheritsFunction) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(30);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, isStrict);
        JSTypeContext typeContext = JSTypeContext.fromJSContext(jsContext, isDeclaration);
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, typeSource, typeContext, isLocal, inheritsFunction);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(31);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSTypeSource typeSource, @NotNull JSTypeContext typeContext, boolean isLocal, boolean inheritsFunction) {
        if (typeSource == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(32);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(33);
        }
        if (qualifiedName == null) {
            JSTopLevelNamespace jSTopLevelNamespace = new JSTopLevelNamespace(typeSource, isLocal, typeContext.toJSContext());
            if (jSTopLevelNamespace == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(34);
            }
            return jSTopLevelNamespace;
        }
        if (isLocal) {
            JSLocalNamedType jSLocalNamedType = new JSLocalNamedType(qualifiedName, typeSource, typeContext, inheritsFunction);
            if (jSLocalNamedType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(35);
            }
            return jSLocalNamedType;
        }
        String typeString = qualifiedName.getQualifiedName();
        JSType type = JSNamedTypeFactory.createType(typeString, typeSource, typeContext, false, inheritsFunction);
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        Object object = type instanceof JSNamespace ? (JSNamespace)type : JSAnyType.get(JSTypeSourceFactory.copyTypeSource(typeSource, false));
        if (object == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(36);
        }
        return object;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict, @Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        JSQualifiedName qName;
        JSNamespace ns;
        String name;
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(37);
        }
        if (StringUtil.isEmpty((String)(name = element.getName()))) {
            return null;
        }
        JSNamespace jSNamespace = ns = visited != null && element instanceof JSDefinitionExpressionImpl ? ((JSDefinitionExpressionImpl)element).calculateSymbolNamespace(visited) : element.getJSNamespace();
        if ("prototype".equals(name)) {
            qName = ns.getQualifiedName();
            jsContext = JSContext.INSTANCE;
        } else {
            qName = JSQualifiedNameImpl.create(name, ns.getQualifiedName());
            jsContext = JSContext.STATIC;
        }
        return JSNamedTypeFactory.createNamespace(qName, jsContext, element instanceof PsiElement ? (PsiElement)element : null, ns.isSourceStrict() && isStrict, true, ns.isLocal());
    }

    public static JSNamespace buildJSNamespace(@NotNull JSElementBase element) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(38);
        }
        return JSNamedTypeFactory.createNamespace(element.getNamespace(), element.getJSContext(), element instanceof PsiElement ? (PsiElement)element : null, element.isNamespaceExplicitlyDeclared());
    }

    @NotNull
    public static JSNamespace fromNamepath(@NotNull String namepath, boolean isExplicitlyDeclared) {
        if (namepath == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(39);
        }
        JSContext jsContext = JSContext.STATIC;
        if (namepath.endsWith(PROTOTYPE_SUFFIX)) {
            namepath = namepath.substring(0, namepath.length() - "prototype".length() - 1);
            jsContext = JSContext.INSTANCE;
        } else if (namepath.endsWith("#")) {
            namepath = namepath.substring(0, namepath.length() - 1);
            jsContext = JSContext.INSTANCE;
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromNamepath(namepath), jsContext, null, isExplicitlyDeclared);
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(40);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSNamespace copyWithJSContext(@NotNull JSNamespace namespace, @NotNull JSContext jsContext) {
        if (namespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(41);
        }
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(42);
        }
        JSNamespace jSNamespace = namespace instanceof JSNamedType ? ((JSNamedType)namespace).copyWithJSContext(jsContext) : namespace;
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(43);
        }
        return jSNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExplicitlyDeclaredType";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespace";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNamepath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExplicitlyDeclaredType";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createNamespace";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildJSNamespace";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyWithJSContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

