/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecursiveTypeUtil {
    private static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> OUR_ALREADY_COMPARED_TYPES_KEY = Key.create((String)"already.compared.types");

    public static <T> T computeWithRecursiveTypes(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext, @NotNull Computation<T> computation, T valueOnFailure) {
        if (type1 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(2);
        }
        if (computation == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(3);
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(type1.getResolvedTypeId(), type2.getResolvedTypeId(), processingContext, computation, valueOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeWithRecursiveTypes(@Nullable JSResolvedTypeId id1, @Nullable JSResolvedTypeId id2, @NotNull ProcessingContext processingContext, @NotNull Computation<T> computation, T valueOnFailure) {
        T result2;
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(4);
        }
        if (computation == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(5);
        }
        if (!JSRecursiveTypeUtil.startRecursiveTypesComparison(id1, id2, processingContext)) {
            return valueOnFailure;
        }
        try {
            result2 = computation.compute(processingContext);
        }
        finally {
            JSRecursiveTypeUtil.endRecursiveTypesComparison(id1, id2, processingContext);
        }
        return result2;
    }

    private static boolean startRecursiveTypesComparison(@Nullable JSResolvedTypeId thisTypeId, @Nullable JSResolvedTypeId elementTypeId, @NotNull ProcessingContext processingContext) {
        Set typesComparedToThis;
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(6);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(OUR_ALREADY_COMPARED_TYPES_KEY, (Object)alreadyComparedTypes);
        }
        if ((typesComparedToThis = (Set)alreadyComparedTypes.get(thisTypeId)) == null) {
            THashSet set = new THashSet();
            set.add((Object)elementTypeId);
            alreadyComparedTypes.put(thisTypeId, set);
            return true;
        }
        return typesComparedToThis.add(elementTypeId);
    }

    private static void endRecursiveTypesComparison(@Nullable JSResolvedTypeId thisTypeId, @Nullable JSResolvedTypeId elementTypeId, @NotNull ProcessingContext processingContext) {
        Set keys;
        Map alreadyComparedTypes;
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(7);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY)) != null && (keys = (Set)alreadyComparedTypes.get(thisTypeId)) != null) {
            keys.remove(elementTypeId);
            if (keys.isEmpty()) {
                alreadyComparedTypes.remove(thisTypeId);
            }
        }
    }

    public static boolean isRecursiveComparison(@NotNull JSResolvedTypeId type1, @NotNull JSResolvedTypeId type2, @NotNull ProcessingContext processingContext) {
        Map alreadyComparedTypes;
        if (type1 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(10);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY)) == null) {
            return false;
        }
        Set typesComparedToThis = (Set)alreadyComparedTypes.get(type1);
        return typesComparedToThis != null && typesComparedToThis.contains(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecursiveTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithRecursiveTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "startRecursiveTypesComparison";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "endRecursiveTypesComparison";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isRecursiveComparison";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Computation<T> {
        public T compute(ProcessingContext var1);
    }
}

