/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeComparingCache {
    public static final Key<JSTypeComparingCache> TYPE_COMPARATOR = Key.create((String)"js.type.comparator.cache");
    public static final Key<Boolean> SUBTYPING_CONTEXT = Key.create((String)"js.type.subtyping");
    private static final Logger LOG = Logger.getInstance(JSTypeComparingCache.class);
    private final boolean myLogDebug;
    private final ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>> myDefaultResult = new ConcurrentHashMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>>();
    private final AtomicLong myCacheMissCount = new AtomicLong();
    private final AtomicLong myCacheUseCount = new AtomicLong();

    public JSTypeComparingCache(Project project) {
        this.myLogDebug = LOG.isDebugEnabled();
    }

    @NotNull
    public JSTypeCastUtil.AssignableResult areAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(0);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(2);
        }
        JSResolvedTypeId lTypeId = JSTypeComparingCache.getTypeId(lType);
        JSResolvedTypeId rTypeId = JSTypeComparingCache.getTypeId(rType);
        if (lTypeId == null || rTypeId == null) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NO_CACHE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(3);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = this.areAssignableIds(lTypeId, rTypeId, processingContext);
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(4);
        }
        return assignableResult;
    }

    public void putAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(5);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(8);
        }
        JSResolvedTypeId lTypeId = JSTypeComparingCache.getTypeId(lType);
        JSResolvedTypeId rTypeId = JSTypeComparingCache.getTypeId(rType);
        if (lTypeId == null || rTypeId == null) {
            return;
        }
        this.putAssignableIds(lTypeId, rTypeId, processingContext, result2);
    }

    @NotNull
    private JSTypeCastUtil.AssignableResult areAssignableIds(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull ProcessingContext context) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(9);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (lType.equals(rType)) {
            this.logUsedCache(lType, rType, JSTypeCastUtil.AssignableResult.ASSIGNABLE);
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(12);
            }
            return assignableResult;
        }
        if (JSRecursiveTypeUtil.isRecursiveComparison(lType, rType, context)) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NO_CACHE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(13);
            }
            return assignableResult;
        }
        ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>> map = this.getCachedMap(context);
        Map compared = map.getOrDefault(lType, Collections.emptyMap());
        JSTypeCastUtil.AssignableResult result2 = compared.getOrDefault(rType, JSTypeCastUtil.AssignableResult.NOT_SURE);
        this.logUsedCache(lType, rType, result2);
        JSTypeCastUtil.AssignableResult assignableResult = result2;
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(14);
        }
        return assignableResult;
    }

    @NotNull
    private ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>> getCachedMap(@NotNull ProcessingContext context) {
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(15);
        }
        ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>> concurrentMap = this.myDefaultResult;
        if (concurrentMap == null) {
            JSTypeComparingCache.$$$reportNull$$$0(16);
        }
        return concurrentMap;
    }

    private void putAssignableIds(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull ProcessingContext context, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(17);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(18);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, JSTypeCastUtil.AssignableResult>> toUse = this.getCachedMap(context);
        Map map = toUse.computeIfAbsent(lType, el -> new ConcurrentHashMap());
        map.putIfAbsent(rType, result2);
        this.logWasCached(lType, rType, result2);
    }

    @Nullable
    private static JSResolvedTypeId getTypeId(@NotNull JSType type) {
        if (type == null) {
            JSTypeComparingCache.$$$reportNull$$$0(21);
        }
        if (!(type instanceof JSNamedType) || !type.isTypeScript()) {
            return null;
        }
        return type.getResolvedTypeId();
    }

    private void logWasCached(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(22);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(24);
        }
        if (this.myLogDebug) {
            LOG.debug(String.format("Cached result %d. ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheMissCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private void logUsedCache(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(25);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(27);
        }
        if (this.myLogDebug && result2.isStrict()) {
            LOG.debug(String.format("Used cached value (%s). ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheUseCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 18: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 8: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableTypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableIds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableIds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeId";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "logWasCached";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "logUsedCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

