/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeGuard
extends JSControlFlowTypeGuard {
    protected TypeScriptTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult, boolean useAutoArrayType, boolean useAutoVariableType, boolean strictNullCheck) {
        if (reference == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(0);
        }
        super(reference, startType, resolveResult, useAutoArrayType, useAutoVariableType, strictNullCheck);
    }

    private static boolean isOptionalProperty(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof JSInitializerOwner && ((JSInitializerOwner)resolveResult).hasInitializer()) {
            return false;
        }
        return resolveResult instanceof JSOptionalOwner && ((JSOptionalOwner)resolveResult).isOptional();
    }

    @Nullable
    private static JSType addUndefinedTypeForOptionalProperties(@Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return startType;
        }
        if (TypeScriptTypeGuard.isOptionalProperty(resolveResult) && startType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            return new JSCompositeTypeImpl(source, startType, JSNamedType.createType("undefined", source, JSContext.UNKNOWN));
        }
        return startType;
    }

    @NotNull
    protected static TypeScriptTypeGuard createTypeScriptTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        if (reference == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(1);
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(reference.getContainingFile());
        boolean useAutoVariableType = false;
        boolean useAutoArrayType = false;
        if (resolveResult instanceof JSVariable && TypeScriptTypeGuard.useAutoTypes(reference, resolveResult, config2)) {
            JSVariable variable = (JSVariable)resolveResult;
            JSExpression initializer = variable.getInitializer();
            useAutoVariableType = !variable.isConst() && (initializer == null || JSSymbolUtil.isUndefinedExpression(initializer) || JSSymbolUtil.isNullLiteral(initializer));
            useAutoArrayType = !useAutoVariableType && TypeScriptTypeGuard.isEmptyArrayExpression(initializer);
        }
        boolean strictNullCheck = config2 != null && config2.strictNullChecks();
        TypeScriptTypeGuard typeScriptTypeGuard = new TypeScriptTypeGuard(reference, TypeScriptTypeGuard.addUndefinedTypeForOptionalProperties(startType, resolveResult, config2), resolveResult, useAutoArrayType, useAutoVariableType, strictNullCheck);
        if (typeScriptTypeGuard == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(2);
        }
        return typeScriptTypeGuard;
    }

    @Override
    @Contract(value="null,_ -> false;_,null -> false")
    protected boolean isMatchingReferenceDiscriminant(@NotNull JSType type, @Nullable PsiElement expression) {
        if (type == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(3);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
        String name = referenceExpression.getReferenceName();
        if (name == null) {
            return false;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier == null) {
            return false;
        }
        if ((type = TypeScriptTypeGuard.getExactType(type)) instanceof JSCompositeTypeImpl) {
            return TypeScriptTypeGuard.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier) && TypeScriptTypeGuard.isDiscriminantProperty(type, name);
        }
        return false;
    }

    @Override
    @NotNull
    protected JSType narrowTypeByDiscriminant(@NotNull JSType type, @NotNull JSExpression expression, @NotNull Function<JSType, JSType> convertType) {
        JSType narrowedPropType;
        if (type == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(5);
        }
        if (convertType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(6);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        String name = ((JSReferenceExpression)expression).getReferenceName();
        if (name == null) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType propType = TypeScriptTypeGuard.getTypeOfPropertyOfType(type, name);
        JSType jSType = narrowedPropType = propType == null ? null : (JSType)convertType.fun((Object)propType);
        if (narrowedPropType == null) {
            JSType jSType2 = type;
            if (jSType2 == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(9);
            }
            return jSType2;
        }
        JSType result2 = propType == narrowedPropType ? type : TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)el -> TypeScriptTypeRelations.isTypeComparableTo(TypeScriptTypeGuard.getTypeOfPropertyOfType(el, name), narrowedPropType, this.myProcessingContext)), (PsiElement)this.myReference);
        JSType jSType3 = TypeScriptTypeGuard.processNeverType(type, result2);
        if (jSType3 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(10);
        }
        return jSType3;
    }

    @Override
    protected boolean containsMatchingReferenceDiscriminant(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (source == null || target == null) {
            return false;
        }
        if (!(target instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression targetRefExpression = (JSReferenceExpression)target;
        String name = targetRefExpression.getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        JSExpression targetQualifier = targetRefExpression.getQualifier();
        if (!TypeScriptTypeGuard.containsMatchingReference(source, (PsiElement)targetQualifier)) {
            return false;
        }
        JSType type = TypeScriptTypeGuard.getExpressionTypeForTypeGuard(targetQualifier);
        return TypeScriptTypeGuard.isDiscriminantProperty(type, name);
    }

    @Override
    @NotNull
    protected JSType narrowByCallExpression(@NotNull JSType rawType, @NotNull JSCallExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(11);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(12);
        }
        JSType jSType = this.narrowTypeByTypePredicate(rawType, (JSExpression)expr, assumeTrue);
        if (jSType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @NotNull
    protected JSType narrowTypeByTypePredicate(@NotNull JSType rawType, JSExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(14);
        }
        if (!this.myIsTypeScript) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        JSType expressionTypeRaw = TypeScriptTypeGuard.getExpressionTypeForTypeGuard(expr);
        JSType expressionJSType = TypeScriptTypeGuard.getExactType(expressionTypeRaw);
        if (!(expressionJSType instanceof TypeScriptTypePredicateTypeImpl)) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        TypeScriptTypePredicateTypeImpl typePredicate = (TypeScriptTypePredicateTypeImpl)expressionJSType;
        JSType guardType = typePredicate.getGuardType();
        if (guardType == null) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        guardType = TypeScriptTypeGuard.getExactType(guardType);
        JSType type = TypeScriptTypeGuard.getExactType(rawType);
        if (TypeScriptTypeGuard.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, guardType)) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSExpression argument = TypeScriptTypeGuard.getExpressionUnderGuard(typePredicate, expr);
        if (!(argument instanceof JSReferenceExpression)) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        if (!TypeScriptTypeGuard.isMatchingReference((PsiElement)this.myReference, (PsiElement)argument)) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(20);
            }
            return jSType;
        }
        if (type instanceof JSAnyType) {
            JSType jSType = rawType;
            if (jSType == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(21);
            }
            return jSType;
        }
        JSType narrowedType = this.getNarrowedType(type, guardType, assumeTrue, (el1, el2) -> TypeScriptTypeRelations.isTypeSubtypeOf(el1, el2, this.mySubtypingProcessingContext));
        JSType jSType = TypeScriptTypeGuard.processNeverType(type, narrowedType);
        if (jSType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    protected static JSExpression getExpressionUnderGuard(@NotNull TypeScriptTypePredicateTypeImpl typePredicate, JSExpression expr) {
        if (typePredicate == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(23);
        }
        if (typePredicate.isThisParameter()) {
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = expr instanceof JSCallExpression ? ((JSCallExpression)expr).getMethodExpression() : expr;
            if (qualifier instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)qualifier).getQualifier();
            }
            return null;
        }
        if (!(expr instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)expr;
        int index = typePredicate.getParameterIndex();
        if (index < 0) {
            return null;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length <= index) {
            return null;
        }
        return arguments[index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertType";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptTypeGuard";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminant";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowByCallExpression";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTypePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptTypeGuard";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceDiscriminant";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminant";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "narrowByCallExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypePredicate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionUnderGuard";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

