/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVisibilityUtil {
    public static final JSAttributeList.AccessType[] ACCESS_TYPES = new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PRIVATE};
    public static final String ESCALATE_VISIBILITY = "escalate";
    public static final Options DEFAULT_OPTIONS = new Options();

    public static boolean seemsToBePrivateSymbol(@Nullable String name) {
        return name != null && !name.isEmpty() && (name.charAt(0) == '_' || name.charAt(name.length() - 1) == '_');
    }

    @Nullable
    public static PresentableAccessModifier getPresentableAccessModifier(@NotNull JSElement element) {
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList;
        if (element == null) {
            JSVisibilityUtil.$$$reportNull$$$0(0);
        }
        JSAttributeList jSAttributeList = attributeList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return PresentableAccessModifier.EXPORT;
        }
        if (element instanceof JSPsiElementBase) {
            accessType = ((JSPsiElementBase)element).getAccessType();
        } else if (attributeList != null) {
            accessType = attributeList.getAccessType();
        } else {
            return null;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
        if (parent instanceof JSPackageStatement || parent instanceof JSClass || attributeList != null && attributeList.getExplicitAccessType() == accessType) {
            return PresentableAccessModifier.ofAccessType(accessType, (PsiElement)element);
        }
        return null;
    }

    public static JSAttributeList.AccessType getEscalatedVisibility(JSAttributeListOwner subject, PsiElement from, @NotNull JSAttributeList.AccessType currentVisibility, @NotNull Options options) {
        if (currentVisibility == null) {
            JSVisibilityUtil.$$$reportNull$$$0(1);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(2);
        }
        if (currentVisibility == JSAttributeList.AccessType.PUBLIC || JSVisibilityUtil.isAccessible((PsiElement)subject, currentVisibility, null, from, options)) {
            return currentVisibility;
        }
        if (DialectDetector.isJavaScriptFamily((PsiElement)subject)) {
            return JSAttributeList.AccessType.PUBLIC;
        }
        JSAttributeList.AccessType escalated = JSAttributeList.AccessType.PUBLIC;
        if (currentVisibility == JSAttributeList.AccessType.PRIVATE) {
            JSClass subjectClass = JSResolveUtil.getClassOfContext((PsiElement)subject);
            JSClass fromClass = JSResolveUtil.getClassOfContext(from);
            escalated = fromClass != null && subjectClass != null && JSInheritanceUtil.isParentClass(fromClass, subjectClass) ? JSAttributeList.AccessType.PROTECTED : JSAttributeList.AccessType.PACKAGE_LOCAL;
        } else if (currentVisibility == JSAttributeList.AccessType.PROTECTED) {
            escalated = JSAttributeList.AccessType.PACKAGE_LOCAL;
        }
        return JSVisibilityUtil.getEscalatedVisibility(subject, from, escalated, options);
    }

    @NotNull
    public static String getVisibilityKeyword(@NotNull JSAttributeList.AccessType visibility) {
        if (visibility == null) {
            JSVisibilityUtil.$$$reportNull$$$0(3);
        }
        if (visibility == JSAttributeList.AccessType.PUBLIC) {
            if ("public" == null) {
                JSVisibilityUtil.$$$reportNull$$$0(4);
            }
            return "public";
        }
        if (visibility == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            if ("internal" == null) {
                JSVisibilityUtil.$$$reportNull$$$0(5);
            }
            return "internal";
        }
        if (visibility == JSAttributeList.AccessType.PRIVATE) {
            if ("private" == null) {
                JSVisibilityUtil.$$$reportNull$$$0(6);
            }
            return "private";
        }
        if (visibility == JSAttributeList.AccessType.PROTECTED) {
            if ("protected" == null) {
                JSVisibilityUtil.$$$reportNull$$$0(7);
            }
            return "protected";
        }
        throw new IncorrectOperationException("Unknown visibility" + visibility);
    }

    @Nullable
    public static JSAttributeList.AccessType parseVisibilityKeyword(String keyword) {
        if (StringUtil.equals((CharSequence)keyword, (CharSequence)"public")) {
            return JSAttributeList.AccessType.PUBLIC;
        }
        if (StringUtil.equals((CharSequence)keyword, (CharSequence)"internal")) {
            return JSAttributeList.AccessType.PACKAGE_LOCAL;
        }
        if (StringUtil.equals((CharSequence)keyword, (CharSequence)"private")) {
            return JSAttributeList.AccessType.PRIVATE;
        }
        if (StringUtil.equals((CharSequence)keyword, (CharSequence)"protected")) {
            return JSAttributeList.AccessType.PROTECTED;
        }
        return null;
    }

    @Nullable
    public static String getJSDocVisibilityKeyword(JSAttributeList.AccessType visibility) {
        switch (visibility) {
            case PUBLIC: {
                return "public";
            }
            case PROTECTED: {
                return "protected";
            }
            case PRIVATE: {
                return "private";
            }
        }
        return null;
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @Nullable JSAttributeList subjectAttributeList, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        String namespace;
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(8);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(9);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(10);
        }
        if (subjectAttributeList == null) {
            JSAttributeList jSAttributeList = subjectAttributeList = subject instanceof JSAttributeListOwner ? ((JSAttributeListOwner)subject).getAttributeList() : null;
            if (subjectAttributeList == null) {
                return true;
            }
        }
        if ((namespace = JSResolveUtil.getNamespaceValue(subjectAttributeList)) != null) {
            return JSVisibilityUtil.isAccessible(subject, namespace, subjectClass, from, options);
        }
        return JSVisibilityUtil.isAccessible(subject, subjectAttributeList.getAccessType(), subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull JSAttributeList.AccessType accessType, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(11);
        }
        if (accessType == null) {
            JSVisibilityUtil.$$$reportNull$$$0(12);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(13);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(14);
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, accessType, subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull String namespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(15);
        }
        if (namespace == null) {
            JSVisibilityUtil.$$$reportNull$$$0(16);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(17);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(18);
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, namespace, subjectClass, from, options);
    }

    private static boolean isAccessibleImpl(@NotNull PsiElement subject, @NotNull Object accessTypeOrNamespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(19);
        }
        if (accessTypeOrNamespace == null) {
            JSVisibilityUtil.$$$reportNull$$$0(20);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(21);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(22);
        }
        if (ActionScriptResolveUtil.isFileLocalSymbol(subject) && (JSVisibilityUtil.getForcedPackage(subject, options) != null || JSVisibilityUtil.getForcedPackage(from, options) != null || subject.getContainingFile() != from.getContainingFile())) {
            return false;
        }
        if (subject instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(subject) == null) {
            PsiFile containingFile;
            if (from.getParent() instanceof JSReferenceListMember && (containingFile = from.getContainingFile()) instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile)) {
                return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC;
            }
            return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC || accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL && JSVisibilityUtil.areInTheSamePackage(subject, from, options) || accessTypeOrNamespace instanceof String;
        }
        if (subjectClass == null) {
            subjectClass = JSUtils.getMemberContainingClass(subject);
        }
        if (subjectClass == null || !JSVisibilityUtil.isAccessible((PsiElement)subjectClass, (JSAttributeList)null, null, from, options)) {
            return false;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC) {
            return true;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            return JSVisibilityUtil.areInTheSamePackage((PsiElement)subjectClass, from, options);
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PROTECTED) {
            JSClass fromClass = from instanceof JSClass ? (JSClass)from : JSResolveUtil.getClassOfContext(from);
            return fromClass != null && (subjectClass.isEquivalentTo((PsiElement)fromClass) || !options.ignoreClassInheritance && JSInheritanceUtil.isParentClass(fromClass, subjectClass));
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PRIVATE) {
            JSClass fromClass = from instanceof JSClass ? (JSClass)from : JSResolveUtil.getClassOfContext(from);
            return fromClass != null && fromClass.isEquivalentTo((PsiElement)subjectClass);
        }
        assert (accessTypeOrNamespace instanceof String);
        return true;
    }

    private static boolean areInTheSamePackage(PsiElement element1, PsiElement element2, Options options) {
        String package2;
        String package1 = JSVisibilityUtil.getPackageName(element1, options);
        return !JSPsiImplUtils.differentPackageName(package1, package2 = JSVisibilityUtil.getPackageName(element2, options));
    }

    private static String getPackageName(PsiElement element, Options options) {
        String packageName = JSVisibilityUtil.getForcedPackage(element, options);
        if (packageName != null) {
            return packageName;
        }
        return element instanceof JSClass ? StringUtil.getPackageName((String)((JSClass)element).getQualifiedName()) : JSResolveUtil.getPackageNameFromPlace(element);
    }

    private static String getForcedPackage(PsiElement element, Options options) {
        String packageName = (String)options.overridePackage.get(element);
        if (packageName == null) {
            packageName = (String)options.overridePackage.get(element.getContainingFile());
        }
        return packageName;
    }

    @NotNull
    public static String accessTypeToKeyword(@NotNull JSAttributeList.AccessType type, @Nullable DialectOptionHolder holder) {
        if (type == null) {
            JSVisibilityUtil.$$$reportNull$$$0(23);
        }
        String s = type == JSAttributeList.AccessType.PACKAGE_LOCAL ? (holder != null && holder.isTypeScript ? "" : "internal") : type.toString().toLowerCase(Locale.ENGLISH);
        String string = s;
        if (string == null) {
            JSVisibilityUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static boolean isAccessible(@NotNull JSPsiElementBase accessedElement, JSAttributeList.AccessType accessedElementVisibility, @NotNull String[] qualifiedReferenceContexts, @NotNull PsiElement referenceScope, boolean fromTheSameFile) {
        if (accessedElement == null) {
            JSVisibilityUtil.$$$reportNull$$$0(25);
        }
        if (qualifiedReferenceContexts == null) {
            JSVisibilityUtil.$$$reportNull$$$0(26);
        }
        if (referenceScope == null) {
            JSVisibilityUtil.$$$reportNull$$$0(27);
        }
        JSQualifiedName accessedElementNamespace = accessedElement.getNamespace();
        switch (accessedElementVisibility) {
            case PROTECTED: 
            case PRIVATE: {
                if (accessedElementVisibility == JSAttributeList.AccessType.PROTECTED && fromTheSameFile) {
                    return true;
                }
                if (accessedElementVisibility == JSAttributeList.AccessType.PRIVATE && fromTheSameFile && JSSymbolUtil.isDefinitelyConstructor((PsiElement)accessedElement)) {
                    return true;
                }
                for (String contextType : qualifiedReferenceContexts) {
                    String namespaceQName;
                    if (contextType == null) {
                        return false;
                    }
                    String string = namespaceQName = accessedElementNamespace != null ? accessedElementNamespace.getQualifiedName() : null;
                    if (!(accessedElementVisibility == JSAttributeList.AccessType.PRIVATE ? contextType.equals(namespaceQName) : accessedElementVisibility == JSAttributeList.AccessType.PROTECTED && (contextType.equals(namespaceQName) || !JSTypeEvaluateManager.iterateTypeHierarchy(referenceScope, contextType, new JSTypeEvaluateManager.NamespaceProcessor(){

                        @Override
                        public boolean process(String serializedType, VirtualFile file2) {
                            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                            return !StringUtil.equals((CharSequence)namespaceQName, (CharSequence)qName);
                        }
                    })))) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static String[] calculateContextNames(PsiElement context) {
        if (context == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                JSVisibilityUtil.$$$reportNull$$$0(28);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> contextNames = new ArrayList<String>();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextNames(context, contextNames);
        }
        while (context != null) {
            JSNamespace ns = JSContextResolver.resolveContext(context);
            String qName = JSNamespace.getQualifiedName((JSNamespace)ns);
            if (qName != null) {
                contextNames.add(qName);
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
        }
        String[] stringArray = ArrayUtil.toStringArray(contextNames);
        if (stringArray == null) {
            JSVisibilityUtil.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    public static JSAttributeList.AccessType getEscalatedJSDocVisibility(@NotNull JSQualifiedNamedElement resolveResult, PsiElement context) {
        boolean fromTheSameFile;
        if (resolveResult == null) {
            JSVisibilityUtil.$$$reportNull$$$0(30);
        }
        JSAttributeList.AccessType accessType = resolveResult.getAccessType();
        boolean bl = fromTheSameFile = context != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)context.getContainingFile());
        if (accessType == JSAttributeList.AccessType.PRIVATE && context != null && JSVisibilityUtil.isAccessible((JSPsiElementBase)resolveResult, JSAttributeList.AccessType.PROTECTED, JSVisibilityUtil.calculateContextNames(context), context, fromTheSameFile)) {
            return JSAttributeList.AccessType.PROTECTED;
        }
        return JSAttributeList.AccessType.PUBLIC;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVisibility";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessTypeOrNamespace";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedReferenceContexts";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceScope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityKeyword";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "accessTypeToKeyword";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateContextNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableAccessModifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEscalatedVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityKeyword";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 28: 
            case 29: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accessTypeToKeyword";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getEscalatedJSDocVisibility";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Options {
        private final Map<PsiElement, String> overridePackage = new HashMap<PsiElement, String>();
        public boolean ignoreClassInheritance = false;

        public void overridePackage(PsiElement element, String packageName) {
            this.overridePackage.put((PsiElement)element.getContainingFile(), packageName);
        }
    }

    public static enum PresentableAccessModifier {
        PUBLIC("public", PlatformIcons.PUBLIC_ICON),
        PRIVATE("private", PlatformIcons.PRIVATE_ICON),
        PROTECTED("protected", PlatformIcons.PROTECTED_ICON),
        EXPORT("export", PlatformIcons.PUBLIC_ICON),
        INTERNAL("internal", PlatformIcons.PACKAGE_LOCAL_ICON);

        private final String myText;
        private final Icon myIcon;

        private PresentableAccessModifier(String text, Icon icon) {
            this.myText = text;
            this.myIcon = icon;
        }

        @Nullable
        static PresentableAccessModifier ofAccessType(@NotNull JSAttributeList.AccessType accessType, @NotNull PsiElement context) {
            if (accessType == null) {
                PresentableAccessModifier.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PresentableAccessModifier.$$$reportNull$$$0(1);
            }
            switch (accessType) {
                case PUBLIC: {
                    return PUBLIC;
                }
                case PACKAGE_LOCAL: {
                    return DialectDetector.isActionScript(context) ? INTERNAL : null;
                }
                case PROTECTED: {
                    return PROTECTED;
                }
                case PRIVATE: {
                    return PRIVATE;
                }
            }
            Logger.getInstance(JSVisibilityUtil.class).error("Not found for " + accessType.toString());
            return null;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                PresentableAccessModifier.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                PresentableAccessModifier.$$$reportNull$$$0(3);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil$PresentableAccessModifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil$PresentableAccessModifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "ofAccessType";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

