/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicIntroducedEntityInfoProvider
implements IntroducedEntityInfoProvider {
    public final JSExpression[] myOccurrences;
    public final JSExpression myMainOccurrence;
    private final PsiElement myScope;

    public BasicIntroducedEntityInfoProvider(@NotNull JSExpression mainOccurrence, JSExpression[] occurrences, PsiElement scope) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(0);
        }
        this.myOccurrences = occurrences;
        this.myMainOccurrence = mainOccurrence;
        this.myScope = scope;
    }

    @Override
    public int getOccurrenceCount() {
        return this.myOccurrences.length;
    }

    @Override
    @Nullable
    public String evaluateType() {
        JSType type = JSResolveUtil.getExpressionJSType(this.myMainOccurrence);
        String finalType = type == null || type instanceof JSAnyType && this.myMainOccurrence instanceof JSReferenceExpression ? BaseCreateFix.guessTypeForExpression(this.myMainOccurrence, this.myMainOccurrence.getContainingFile(), false) : type.getTypeText(JSType.TypeTextFormat.CODE);
        String typeString = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)finalType, (PsiElement)this.myMainOccurrence, (boolean)false, (boolean)false).first);
        return typeString;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myMainOccurrence.getContainingFile();
    }

    @Override
    public String[] suggestCandidateNames() {
        return ArrayUtil.toStringArray(JSNameSuggestionsUtil.generateVariableNamesFromExpression(this.myMainOccurrence, this.myScope, Collections.emptyList()));
    }

    @Override
    public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurences) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(1);
        }
        PsiElement scope = this.myScope;
        assert (scope != null);
        JSNamedElement existing = JSNameSuggestionsUtil.findExistingInScopeAndUp(name, scope);
        if (existing != null) {
            return BasicIntroducedEntityInfoProvider.showMemberAlreadyExists((PsiElement)existing);
        }
        return true;
    }

    public static boolean showMemberAlreadyExists(@NotNull PsiElement existing) {
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(2);
        }
        String description = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)existing, (boolean)false));
        String msg = JSBundle.message((String)"javascript.introduce.element.already.exists", (Object[])new Object[]{description});
        MultiMap conflicts = new MultiMap();
        conflicts.putValue((Object)existing, (Object)msg);
        return new ConflictsDialog(existing.getProject(), conflicts).showAndGet();
    }

    @Override
    public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(3);
        }
        return (PsiElement)ContainerUtil.getFirstItem(BasicIntroducedEntityInfoProvider.findExistingInScope(name, place, this.processStatics(place)));
    }

    @NotNull
    public static List<PsiElement> findExistingInScope(@NotNull String name, @Nullable PsiElement scope, boolean processStatics) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
        processor.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        if (scope instanceof JSClass) {
            processor.configureClassScope((JSClass)scope);
        }
        PsiElement realPlace = scope;
        if (scope instanceof JSObjectLiteralExpression) {
            scope = ((JSObjectLiteralExpression)scope).getFirstProperty();
        }
        scope.processDeclarations(processor, ResolveState.initial(), scope, realPlace);
        List list = (List)ObjectUtils.notNull(JSResolveResult.toElements(processor.getResultsAsResolveResults()), (Object)ContainerUtil.emptyList());
        if (list == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    protected boolean processStatics(PsiElement place) {
        return JSResolveUtil.calculateStaticFromContext(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showMemberAlreadyExists";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementInScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScope";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

