/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroducedExpressionReplacer {
    private final JSExpression myExpression;
    private final String myExpressionText;
    private final TextRange myRelativeRange;
    private final boolean myIsIntroducingPartOfExpression;

    public JSIntroducedExpressionReplacer(Pair<JSExpression, TextRange> expressionDescriptor) {
        this.myExpression = (JSExpression)expressionDescriptor.first;
        this.myIsIntroducingPartOfExpression = JSIntroducedExpressionReplacer.isIntroducingPartOfExpression(expressionDescriptor);
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        TextRange range = (TextRange)expressionDescriptor.second;
        if (range == null) {
            range = expression.getTextRange();
        }
        if (expression instanceof JSXmlLiteralExpressionImpl && (expression.getParent() instanceof JSXmlLiteralExpressionImpl || this.isIntroducingPartOfExpression())) {
            expression = JSIntroducedExpressionReplacer.findTopXmlLiteralExpression(expression);
        }
        this.myExpressionText = expression.getText();
        this.myRelativeRange = range.shiftLeft(expression.getTextRange().getStartOffset());
    }

    public static boolean willReplacePartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionReplacer.willReplacePartOfExpression(JSIntroducedExpressionReplacer.isIntroducingPartOfExpression(expressionDescriptor), (JSExpression)expressionDescriptor.first);
    }

    public JSExpression replaceExpression(@NotNull JSExpression replacementExpression) {
        if (replacementExpression == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(0);
        }
        return this.replaceOccurrence(this.myExpression, replacementExpression);
    }

    @Nullable
    public JSExpression replaceOccurrence(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
        JSExpression replaced;
        if (toReplace == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(1);
        }
        if (replacementExpression == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(2);
        }
        if (JSIntroducedExpressionReplacer.willReplacePartOfExpression(this.isIntroducingPartOfExpression(), toReplace) && (replaced = this.tryReplacePartOfExpression(toReplace, replacementExpression)) != null) {
            int offset = this.myRelativeRange.getStartOffset();
            return JSIntroducedExpressionReplacer.findReferenceToIntroduced(replaced, replacementExpression, offset);
        }
        return toReplace.replace(replacementExpression);
    }

    private static boolean willReplacePartOfExpression(boolean partialRangeSelected, @NotNull JSExpression occurrence) {
        if (occurrence == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(3);
        }
        if (occurrence instanceof JSXmlLiteralExpressionImpl && (occurrence.getParent() instanceof JSXmlLiteralExpressionImpl || partialRangeSelected)) {
            return true;
        }
        if (!partialRangeSelected) {
            return false;
        }
        return occurrence instanceof JSStringTemplateExpression || occurrence instanceof JSLiteralExpression && ((JSLiteralExpression)occurrence).isQuotedLiteral() || occurrence instanceof JSBinaryExpression;
    }

    public String getIntroducedExpressionText() {
        String text = this.myExpressionText;
        text = this.myRelativeRange.substring(text);
        JSExpression expression = this.myExpression;
        if (expression instanceof JSXmlLiteralExpressionImpl) {
            return "<>" + text + "</>";
        }
        if (expression instanceof JSLiteralExpression) {
            if (((JSLiteralExpression)expression).isQuotedLiteral() && this.isIntroducingPartOfExpression()) {
                String quote = this.myExpressionText.substring(0, 1);
                return quote + text + quote;
            }
            return this.myExpressionText;
        }
        return text;
    }

    private static JSExpression findTopXmlLiteralExpression(JSExpression expression) {
        PsiElement myParent;
        while ((myParent = expression.getParent()) instanceof JSXmlLiteralExpressionImpl) {
            expression = (JSExpression)myParent;
        }
        return expression;
    }

    private static boolean isIntroducingPartOfExpression(@NotNull Pair<JSExpression, TextRange> descriptor2) {
        if (descriptor2 == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(4);
        }
        return descriptor2.second != null;
    }

    private boolean isIntroducingPartOfExpression() {
        return this.myIsIntroducingPartOfExpression;
    }

    @Nullable
    private JSExpression tryReplacePartOfExpression(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
        if (toReplace == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(5);
        }
        if (replacementExpression == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(6);
        }
        if (toReplace instanceof JSXmlLiteralExpressionImpl && (toReplace.getParent() instanceof JSXmlLiteralExpressionImpl || this.isIntroducingPartOfExpression())) {
            toReplace = JSIntroducedExpressionReplacer.findTopXmlLiteralExpression(toReplace);
            return toReplace.replace(this.buildTextForReplacement(replacementExpression, "{", "}"));
        }
        if (this.isIntroducingPartOfExpression()) {
            if (toReplace instanceof JSStringTemplateExpression) {
                String prefix = "${";
                String replacementText = this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + prefix + replacementExpression.getText() + "}" + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
                JSExpression replacement = JSChangeUtil.createExpressionPsiWithContext(replacementText, (PsiElement)replacementExpression, JSExpression.class);
                return toReplace.replace(replacement);
            }
            if (toReplace instanceof JSLiteralExpression && ((JSLiteralExpression)toReplace).isQuotedLiteral()) {
                String quote = toReplace.getText().substring(0, 1);
                return toReplace.replace(this.buildTextForReplacement(replacementExpression, quote + " + ", " + " + quote));
            }
            if (toReplace instanceof JSBinaryExpression) {
                return toReplace.replace(this.buildTextForReplacement(replacementExpression, "", ""));
            }
        }
        return null;
    }

    @Nullable
    private JSExpression buildTextForReplacement(JSExpression refExpr, String quote, String quote2) {
        String text = "";
        if (this.myRelativeRange.getStartOffset() > 1) {
            text = text + this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + quote;
        }
        text = text + refExpr.getText();
        if (this.myRelativeRange.getEndOffset() < this.myExpressionText.length() - 1) {
            text = text + quote2 + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
        }
        return JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)refExpr, JSExpression.class);
    }

    @Nullable
    private static JSExpression findReferenceToIntroduced(@NotNull JSExpression topExpression, @NotNull JSExpression toSearch, int startOffset) {
        if (topExpression == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(7);
        }
        if (toSearch == null) {
            JSIntroducedExpressionReplacer.$$$reportNull$$$0(8);
        }
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)topExpression, element -> {
            if (toSearch == null) {
                JSIntroducedExpressionReplacer.$$$reportNull$$$0(9);
            }
            if (element instanceof JSExpression && element.getTextRange().getStartOffset() >= startOffset && StringUtil.equals((CharSequence)element.getText(), (CharSequence)toSearch.getText())) {
                result2.set((Object)((JSExpression)element));
                return false;
            }
            return true;
        });
        return (JSExpression)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementExpression";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSearch";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionReplacer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceOccurrence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "willReplacePartOfExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntroducingPartOfExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "tryReplacePartOfExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceToIntroduced";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findReferenceToIntroduced$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

