/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class JavaScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public JavaScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
        super(typeChecker);
    }

    @Override
    protected void checkCallArgumentType(JSParameterItem p, JSExpression expression, JSCallExpression node, PsiElement resolveResult) {
        JSParameter elementToChangeType;
        JSFunctionSignatureChecker.DefaultReporter reporter = this.createReporter(expression);
        JSType type = this.addGenericArgumentsAndFillConstraintProblems(p.getTypeIncludingOverridden(), expression, node, resolveResult, reporter);
        ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)expression);
        JSParameter jSParameter = elementToChangeType = p instanceof JSParameter ? (JSParameter)p : null;
        if (this.myTypeChecker.checkExpressionIsAssignableToType(expression, type, null, "javascript.argument.type.mismatch", (PsiElement)elementToChangeType, processingContext, false)) {
            reporter.reportGenericErrorIfExist();
        }
    }

    @Override
    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (type != null && methodExpression instanceof JSReferenceExpression) {
            PsiElement sourceElement = type.getSource().getSourceElement();
            if (sourceElement != null && DialectDetector.isTypeScript(sourceElement)) {
                type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(type, methodExpression, resolveResult, reporter);
            } else {
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null) {
                    type = JSGenericTypesEvaluator.getInstance().evaluateGenericsFromQualifier(type, qualifier, (JSExpression)((JSReferenceExpression)methodExpression));
                }
            }
        }
        return type;
    }
}

