/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeSignatureWithDelegationUpdateFix
extends ChangeSignatureFix {
    private final SmartPsiElementPointer<JSCallExpression> myNode;
    private final String myCallName;

    public ChangeSignatureWithDelegationUpdateFix(JSFunction function, List<JSParameterInfo> parameterInfos, JSCallExpression node) {
        super(function, parameterInfos);
        this.myNode = SmartPointerManager.createPointer((PsiElement)node);
        JSExpression methodExpression = node.getMethodExpression();
        this.myCallName = methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSSuperExpression ? "'" + methodExpression.getText() + "'" : JSBundle.message((String)"change.method.signature.delegating.default.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(0);
        }
        if (this.myNode.getElement() == null) {
            return false;
        }
        return super.isAvailable(project, editor, file2);
    }

    @Override
    public void invoke(PsiElement context) throws IncorrectOperationException {
        super.invoke(context);
        ApplicationManager.getApplication().runWriteAction(() -> {
            JSCallExpression element = (JSCallExpression)this.myNode.getElement();
            assert (element != null);
            JSExpression[] arguments = element.getArguments();
            JSExpression expression = element.getMethodExpression();
            StringBuilder builder = new StringBuilder(expression.getText());
            builder.append('(');
            for (JSExpression arg : arguments) {
                builder.append(arg.getText());
                builder.append(',');
            }
            for (int i = arguments.length; i < this.myParamInfos.size(); ++i) {
                builder.append(((JSParameterInfo)this.myParamInfos.get(i)).getName());
                if (i >= this.myParamInfos.size() - 1) continue;
                builder.append(',');
            }
            builder.append(')');
            JSChangeUtil.replaceExpression((JSExpression)element, (JSExpression)JSChangeUtil.createExpressionWithContext(builder.toString(), (PsiElement)element).getPsi());
        });
    }

    @Override
    @NotNull
    public String getText() {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            String string = JSBundle.message((String)"change.method.signature.and.update.delegating.call.noname.fix.text", (Object[])new Object[]{this.myCallName});
            if (string == null) {
                ChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JSBundle.message((String)"change.method.signature.and.update.delegating.call.fix.text", (Object[])new Object[]{JSFormatUtil.formatMethod(function, 4353, 0, 0, null), this.myCallName});
        if (string == null) {
            ChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ChangeSignatureWithDelegationUpdateFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ChangeSignatureWithDelegationUpdateFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

