/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListWrapper {
    public static final JSAttributeList.ModifierType[] MODIFIERS = new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.EXPORT, JSAttributeList.ModifierType.DECLARE, JSAttributeList.ModifierType.CONST, JSAttributeList.ModifierType.OVERRIDE, JSAttributeList.ModifierType.VIRTUAL, JSAttributeList.ModifierType.STATIC, JSAttributeList.ModifierType.ABSTRACT, JSAttributeList.ModifierType.READONLY, JSAttributeList.ModifierType.FINAL, JSAttributeList.ModifierType.NATIVE, JSAttributeList.ModifierType.DYNAMIC, JSAttributeList.ModifierType.ASYNC};
    @Nullable
    private final JSAttributeList myAttributeList;
    @NotNull
    private final Project myProject;
    @Nullable
    private JSAttributeList.AccessType myAccessTypeOverride;
    private final Map<JSAttributeList.ModifierType, Boolean> myModifiers;
    @Nullable
    private String myNamespace;
    private final List<Attribute> myAdditionalAttributes;
    private boolean myRemoveOriginalAttributes;
    private boolean myNullAccessModifier;
    private static final Function<JSAttributeNameValuePair, Pair<String, String>> VALUE_MAPPER = pair -> Pair.create((Object)pair.getName(), (Object)pair.getSimpleValue());
    private static final Function<JSAttribute, Attribute> ATTRIBUTE_MAPPER = jsAttribute -> new Attribute(jsAttribute.getName(), ContainerUtil.map((Object[])jsAttribute.getValues(), VALUE_MAPPER));

    @Nullable
    private String getConditionalCompileVariableReference() {
        if (this.myAttributeList == null) {
            return null;
        }
        JSConditionalCompileVariableReference ref = this.myAttributeList.getConditionalCompileVariableReference();
        return ref != null ? ref.getText() : null;
    }

    public JSAttributeListWrapper(@Nullable JSAttributeList attributeList, @NotNull Project project) {
        if (project == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(0);
        }
        this.myModifiers = new HashMap<JSAttributeList.ModifierType, Boolean>();
        this.myAdditionalAttributes = new ArrayList<Attribute>();
        this.myAttributeList = attributeList;
        this.myProject = project;
    }

    public void overrideAccessType(@NotNull JSAttributeList.AccessType accessTypeOverride) {
        if (accessTypeOverride == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(1);
        }
        this.myAccessTypeOverride = accessTypeOverride;
        this.myNamespace = null;
        this.myNullAccessModifier = false;
    }

    public void overrideNamespace(@NotNull String namespace) {
        if (namespace == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(2);
        }
        this.myNamespace = namespace;
        this.myAccessTypeOverride = null;
        this.myNullAccessModifier = false;
    }

    public void removeAccessModifier() {
        this.myNullAccessModifier = true;
    }

    @Nullable
    private JSAttributeList.AccessType getAccessType() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myAccessTypeOverride != null) {
            return this.myAccessTypeOverride;
        }
        if (this.myNamespace != null) {
            return null;
        }
        return this.myAttributeList != null ? this.myAttributeList.getExplicitAccessType() : null;
    }

    @Nullable
    private String getNamespace() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myNamespace != null) {
            return this.myNamespace;
        }
        if (this.myAccessTypeOverride != null) {
            return null;
        }
        return this.myAttributeList != null ? this.myAttributeList.getNamespace() : null;
    }

    private boolean hasModifier(JSAttributeList.ModifierType modifierType) {
        Boolean flag = this.myModifiers.get(modifierType);
        if (flag != null) {
            return flag;
        }
        if (this.myAttributeList == null) {
            return false;
        }
        JSAttributeListStub stub = (JSAttributeListStub)this.myAttributeList.getStub();
        return stub != null ? stub.hasModifier(modifierType) : this.myAttributeList.hasExplicitModifier(modifierType);
    }

    public void overrideModifier(JSAttributeList.ModifierType modifierType, boolean exists) {
        this.myModifiers.put(modifierType, exists);
    }

    public void addAttribute(String name, String valueName, String value) {
        this.myAdditionalAttributes.add(new Attribute(name, Collections.singletonList(Pair.create((Object)valueName, (Object)value))));
    }

    private List<Attribute> getAttributes() {
        ArrayList<Attribute> result2 = new ArrayList<Attribute>();
        if (this.myAttributeList != null && !this.myRemoveOriginalAttributes) {
            result2.addAll(ContainerUtil.map((Object[])this.myAttributeList.getAttributes(), ATTRIBUTE_MAPPER));
        }
        result2.addAll(this.myAdditionalAttributes);
        return result2;
    }

    public String computeText(@Nullable JSAttributeListOwner targetElement, @Nullable DialectOptionHolder dialectOptionHolder) {
        JSAttributeList.AccessType accessType;
        StringBuilder result2 = new StringBuilder();
        for (Attribute attribute : this.getAttributes()) {
            JSAttributeListWrapper.appendWithSpace(result2, "[");
            result2.append(attribute.name);
            if (attribute.getSimpleValue() != null) {
                result2.append("(\"").append(attribute.getSimpleValue()).append("\")");
            } else if (!attribute.nameValuePairs.isEmpty()) {
                result2.append("(");
                for (int i = 0; i < attribute.nameValuePairs.size(); ++i) {
                    if (i > 0) {
                        result2.append(",");
                    }
                    Pair<String, String> value = attribute.nameValuePairs.get(i);
                    result2.append((String)value.first).append("=\"").append((String)value.second).append("\"");
                }
                result2.append(")");
            }
            result2.append("]");
        }
        String compileVariableReference = this.getConditionalCompileVariableReference();
        if (compileVariableReference != null) {
            JSAttributeListWrapper.appendWithSpace(result2, compileVariableReference);
        }
        if (this.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
            JSAttributeListWrapper.appendWithSpace(result2, JSAttributeList.ModifierType.OVERRIDE.keyword);
        }
        if ((accessType = this.getAccessType()) == null && dialectOptionHolder != null && dialectOptionHolder.isTypeScript) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        }
        if (accessType != null) {
            String keyword;
            if (accessType == JSAttributeList.AccessType.PRIVATE && dialectOptionHolder != null && dialectOptionHolder.hasFeature(JSLanguageFeature.PRIVATE_SHARP_SYNTAX) && this.myAttributeList != null && this.myAttributeList.getExplicitAccessType() == accessType) {
                result2.append("#");
            } else if (this.needAccessKeyword(accessType, targetElement, dialectOptionHolder) && !StringUtil.isEmpty((String)(keyword = JSVisibilityUtil.getVisibilityKeyword(accessType)))) {
                JSAttributeListWrapper.appendWithSpace(result2, keyword);
            }
        } else {
            String namespace = this.getNamespace();
            if (namespace != null) {
                JSAttributeListWrapper.appendWithSpace(result2, namespace);
            }
        }
        for (JSAttributeList.ModifierType modifier : MODIFIERS) {
            if (modifier == JSAttributeList.ModifierType.OVERRIDE || !this.hasModifier(modifier)) continue;
            JSAttributeListWrapper.appendWithSpace(result2, modifier.keyword);
        }
        return result2.toString();
    }

    private boolean needAccessKeyword(@NotNull JSAttributeList.AccessType accessType, @Nullable JSAttributeListOwner targetElement, @Nullable DialectOptionHolder dialectOptionHolder) {
        if (accessType == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(3);
        }
        if (dialectOptionHolder != null && dialectOptionHolder.isECMA6) {
            return false;
        }
        if (JSClassUtils.isES6ClassImplementation(dialectOptionHolder) && targetElement instanceof JSClass) {
            return false;
        }
        if (this.myAttributeList == null) {
            return accessType != JSAttributeList.AccessType.PUBLIC || this.shouldAddPublicModifier(dialectOptionHolder, targetElement);
        }
        return dialectOptionHolder != null && dialectOptionHolder.isECMA4 || accessType != JSAttributeList.AccessType.PUBLIC || this.shouldAddPublicModifier(dialectOptionHolder, targetElement);
    }

    private boolean shouldAddPublicModifier(@Nullable DialectOptionHolder dialectOptionHolder, JSAttributeListOwner targetElement) {
        if (dialectOptionHolder == null || !dialectOptionHolder.isTypeScript || this.myNullAccessModifier) {
            return false;
        }
        if (TypeScriptCodeStyleSettings.getTypeScriptSettings((Project)this.myProject).USE_PUBLIC_MODIFIER) {
            return true;
        }
        if (!(targetElement instanceof JSParameter)) {
            return false;
        }
        return this.myAttributeList == null || this.myRemoveOriginalAttributes || !this.myAttributeList.hasModifier(JSAttributeList.ModifierType.READONLY);
    }

    public void removeOriginalAttributes() {
        this.myRemoveOriginalAttributes = true;
    }

    public void applyTo(@NotNull JSAttributeListOwner targetElement) {
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(4);
        }
        JSAttributeList attributeList = targetElement.getAttributeList();
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)targetElement);
        String text = this.computeText(targetElement, DialectDetector.dialectOfElement((PsiElement)targetElement));
        if (targetElement instanceof JSVariable && targetElement.getParent() instanceof JSAttributeListOwner) {
            targetElement = (JSAttributeListOwner)targetElement.getParent();
        }
        if (text.length() > 0) {
            PsiElement nextSibling;
            PsiElement insertBefore;
            String functionStr = languageDialect != null && languageDialect.getOptionHolder().isECMA4 ? " function " : " ";
            String sharp = "";
            if (text.endsWith("#")) {
                text = text.substring(0, text.length() - 1).trim();
                sharp = "#";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.GET)) {
                functionStr = functionStr + "get ";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.SET)) {
                functionStr = functionStr + "set ";
            }
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.GENERATOR)) {
                functionStr = functionStr + " *";
            }
            JSAttributeList newAttributeList = JSAttributeListWrapper.createAttributeList(targetElement, languageDialect, text, functionStr, sharp);
            JSAttributeListWrapper.copyDecorators(attributeList, newAttributeList);
            if (attributeList == null) {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)targetElement, JSDocComment.class);
                insertBefore = docComment != null ? docComment.getNextSibling() : targetElement.getFirstChild();
            } else if (attributeList.getFirstChild() == null) {
                insertBefore = attributeList.getNextSibling();
                attributeList.delete();
            } else {
                nextSibling = attributeList.getNextSibling();
                while (nextSibling instanceof PsiWhiteSpace) {
                    nextSibling = nextSibling.getNextSibling();
                }
                insertBefore = nextSibling;
                targetElement.deleteChildRange((PsiElement)attributeList, insertBefore.getPrevSibling());
            }
            nextSibling = newAttributeList.getNextSibling();
            targetElement.addRangeBefore((PsiElement)newAttributeList, (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : newAttributeList), insertBefore);
        } else if (attributeList != null) {
            if (attributeList.getNode().getChildren(null).length == 0) {
                return;
            }
            PsiElement firstChild = attributeList.getFirstChild();
            PsiElement lastChild = attributeList.getLastChild();
            boolean hasGet = attributeList.hasModifier(JSAttributeList.ModifierType.GET);
            boolean hasSet = attributeList.hasModifier(JSAttributeList.ModifierType.SET);
            JSAttributeList newAttributeList = null;
            if (hasGet || hasSet) {
                newAttributeList = JSAttributeListWrapper.createAttributeList(targetElement, languageDialect, hasGet ? "get " : "set ", "", "");
            }
            if (newAttributeList == null) {
                newAttributeList = (JSAttributeList)JSChangeUtil.createCompositeElementWithDummyHolder((PsiElement)attributeList, JSStubElementTypes.ATTRIBUTE_LIST).getPsi();
            }
            if (newAttributeList != null) {
                JSAttributeListWrapper.copyDecorators(attributeList, newAttributeList);
            }
            if (newAttributeList != null) {
                PsiElement nextSibling = newAttributeList.getNextSibling();
                targetElement.addRangeBefore((PsiElement)newAttributeList, (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : newAttributeList), (PsiElement)attributeList);
            }
            if (firstChild != null) {
                if (lastChild instanceof LeafPsiElement && ((LeafPsiElement)lastChild).getElementType() == JSTokenTypes.SHARP) {
                    targetElement.deleteChildRange((PsiElement)attributeList, (PsiElement)attributeList);
                } else {
                    targetElement.deleteChildRange((PsiElement)attributeList, attributeList.getNextSibling());
                }
            }
        }
    }

    private static void copyDecorators(@Nullable JSAttributeList attributeList, @NotNull JSAttributeList newAttributeList) {
        ES6Decorator[] decorators;
        if (newAttributeList == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(5);
        }
        if (attributeList != null && (decorators = (ES6Decorator[])PsiTreeUtil.getChildrenOfType((PsiElement)attributeList, ES6Decorator.class)) != null) {
            for (int i = 0; i < decorators.length; ++i) {
                ES6Decorator decorator = decorators[i];
                PsiElement newDecorator = newAttributeList.addAfter((PsiElement)decorator, null);
                if (i != decorators.length - 1) continue;
                PsiElement sibling = decorator.getNextSibling();
                PsiElement anchor = newDecorator;
                while (sibling instanceof PsiWhiteSpace) {
                    anchor = newAttributeList.addAfter(sibling, anchor);
                    sibling = sibling.getNextSibling();
                }
            }
        }
    }

    @NotNull
    private static JSAttributeList createAttributeList(@NotNull JSAttributeListOwner targetElement, JSLanguageDialect languageDialect, String text, String functionStr, String sharp) {
        if (targetElement == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(6);
        }
        PsiElement dummyDeclaration = targetElement instanceof JSClass ? (PsiElement)JSChangeUtil.createStatementPsiFromTextWithContext(text + " class dummy {}", (PsiElement)targetElement, JSClass.class) : JSChangeUtil.createClassMemberFromText(targetElement.getProject(), text + functionStr + sharp + "dummy(){ }", languageDialect).getPsi();
        JSAttributeList jSAttributeList = (JSAttributeList)ObjectUtils.assertNotNull((Object)((JSAttributeListOwner)ObjectUtils.assertNotNull((Object)dummyDeclaration)).getAttributeList());
        if (jSAttributeList == null) {
            JSAttributeListWrapper.$$$reportNull$$$0(7);
        }
        return jSAttributeList;
    }

    private static void appendWithSpace(StringBuilder s, String text) {
        if (s.length() > 0) {
            s.append(" ");
        }
        s.append(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessTypeOverride";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAttributeList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "overrideAccessType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "overrideNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "needAccessKeyword";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyDecorators";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeList";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Attribute {
        public final String name;
        public final List<Pair<String, String>> nameValuePairs;

        @Nullable
        public String getSimpleValue() {
            return this.nameValuePairs.size() == 1 && this.nameValuePairs.get((int)0).first == null ? (String)this.nameValuePairs.get((int)0).second : null;
        }

        public Attribute(String name, List<Pair<String, String>> nameValuePairs) {
            this.name = name;
            this.nameValuePairs = Collections.unmodifiableList(nameValuePairs);
        }
    }
}

