/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInsertTypeGuardFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;
    private final TypeGuardSurroundKind mySurroundKind;
    private final String myDiscriminatedPropertyName;
    private final boolean myIsNegative;
    private final boolean myAllowSimplifyForNullable;
    private static final String myTypeOfTemplate = "typeof %s === %s";
    private static final String myTypeOfNegativeTemplate = "typeof %s !== %s";
    private static final String myInstanceOfTemplate = "%s instanceof %s";
    private final JSType myType;

    public TypeScriptInsertTypeGuardFix(@Nullable PsiElement element, @NotNull JSType type, @NotNull TypeGuardSurroundKind surroundKind, @Nullable String discriminatedPropertyName, boolean isNegative, boolean allowSimplifyForNullable) {
        if (type == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(0);
        }
        if (surroundKind == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myType = type;
        this.myName = type.getTypeText(JSType.TypeTextFormat.CODE);
        this.mySurroundKind = surroundKind;
        this.myDiscriminatedPropertyName = discriminatedPropertyName;
        this.myIsNegative = isNegative;
        this.myAllowSimplifyForNullable = allowSimplifyForNullable;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        JSClass clazz;
        JSResolvedTypeInfo info;
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(5);
        }
        if (!(this.myDiscriminatedPropertyName != null || this.isTypeOfMember(this.myName) || this.myType instanceof JSNullType || this.myType instanceof JSUndefinedType || this.myType instanceof JSResolvableType)) {
            return false;
        }
        if (this.myDiscriminatedPropertyName == null && !this.isTypeOfMember(this.myName) && this.myType instanceof JSResolvableType && (info = ((JSResolvableType)this.myType).resolveType()) != null && ((clazz = info.getDeclarationOfType(JSClass.class)) == null || clazz.isInterface() || clazz instanceof TypeScriptTypeAlias)) {
            return false;
        }
        if (this.myDiscriminatedPropertyName == null && TypeScriptUtil.hasAmbientExternalModuleInQName(this.myName) && TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement))) {
            return false;
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return false;
        }
        if (variable.getType() instanceof JSPrimitiveType && (!(variable instanceof JSParameter) || !((JSParameter)variable).isOptional()) && this.isTypeOfMember(this.myName)) {
            return false;
        }
        String name = variable.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        PsiElement parent = this.computeParent(startElement);
        if ((this.mySurroundKind == TypeGuardSurroundKind.IfStatement || this.mySurroundKind == TypeGuardSurroundKind.SwitchStatement) && (parent instanceof JSExpressionStatement || parent instanceof JSVarStatement)) {
            return true;
        }
        return (this.mySurroundKind == TypeGuardSurroundKind.Ternary || this.mySurroundKind == TypeGuardSurroundKind.And || this.mySurroundKind == TypeGuardSurroundKind.Or) && parent instanceof JSExpression;
    }

    @Nullable
    private static JSFieldVariable getResolvedVariable(@Nullable PsiElement startElement) {
        PsiElement resolve;
        if (startElement instanceof JSVariable) {
            return (JSVariable)startElement;
        }
        if (startElement instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)startElement).resolve()) instanceof JSFieldVariable) {
            return (JSFieldVariable)resolve;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            return;
        }
        PsiElement parent = this.computeParent(startElement);
        if (parent == null) {
            return;
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return;
        }
        String shortenedType = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        boolean isTypeOf = this.isTypeOfMember(shortenedType);
        String name = startElement instanceof JSVariable ? variable.getName() : startElement.getText();
        Template template = templateManager.createTemplate("", "", String.format(this.getTemplate(shortenedType), name, isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(shortenedType) : shortenedType));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = parent.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + parent.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, parent.getText(), template);
    }

    @Nullable
    private PsiElement computeParent(@NotNull PsiElement startElement) {
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(10);
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.IfStatement || this.mySurroundKind == TypeGuardSurroundKind.SwitchStatement) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        }
        return this.getOwnerExpression(startElement);
    }

    @Nullable
    private JSExpression getOwnerExpression(@Nullable PsiElement expression) {
        if (!(expression instanceof JSExpression)) {
            return null;
        }
        PsiElement parentExpression = expression.getParent();
        if (parentExpression instanceof JSCallExpression) {
            return this.getOwnerExpression(parentExpression);
        }
        if (parentExpression instanceof JSReferenceExpression) {
            return this.getOwnerExpression(parentExpression);
        }
        if (parentExpression instanceof JSBinaryExpression) {
            if (((JSBinaryExpression)parentExpression).getROperand() == expression) {
                IElementType sign = ((JSBinaryExpression)parentExpression).getOperationSign();
                if (!(this.mySurroundKind != TypeGuardSurroundKind.And && this.mySurroundKind != TypeGuardSurroundKind.Or || sign != JSTokenTypes.ANDAND && sign != JSTokenTypes.OROR)) {
                    return (JSExpression)expression;
                }
            }
            return (JSExpression)parentExpression;
        }
        return (JSExpression)expression;
    }

    public boolean isTypeOfMember(@NotNull String typeofWrapType) {
        if (typeofWrapType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(11);
        }
        return ArrayUtil.contains((String)typeofWrapType, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    private static String wrapWithQuotes(@NotNull String shortenedType) {
        if (shortenedType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(12);
        }
        String string = '\"' + shortenedType + '\"';
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getActionText();
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    private boolean isSurround() {
        switch (this.mySurroundKind) {
            case IfStatement: 
            case SwitchStatement: {
                return true;
            }
            case Ternary: 
            case And: 
            case Or: {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private String getActionText() {
        String string = JSBundle.message((String)(this.isSurround() ? "typescript.insert.type.guard.surround" : "typescript.insert.type.guard.prefix"), (Object[])new Object[]{this.createGuardTextDescription()});
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private String getTemplate(String typeName) {
        String template = this.myDiscriminatedPropertyName != null ? this.computeTemplateForDiscriminator() : (this.myType instanceof JSNullType || this.myType instanceof JSUndefinedType ? this.computeTemplateForNullable() : this.computeTypeOfOrInstanceOfTemplate(typeName));
        switch (this.mySurroundKind) {
            case IfStatement: {
                String string = "if (" + template + ") {$SELECTION$}";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(16);
                }
                return string;
            }
            case Ternary: {
                String string = template + " ? $SELECTION$ : $END$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(17);
                }
                return string;
            }
            case And: {
                String string = template + " && $SELECTION$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(18);
                }
                return string;
            }
            case Or: {
                String string = template + " || $SELECTION$";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(19);
                }
                return string;
            }
            case SwitchStatement: {
                assert (this.myDiscriminatedPropertyName != null);
                String string = "switch (%s." + this.myDiscriminatedPropertyName + ") { case %s: $SELECTION$ }";
                if (string == null) {
                    TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        throw new NotImplementedError("Unknown surround kind: " + ((Object)((Object)this.mySurroundKind)).getClass());
    }

    @NotNull
    private String computeTemplateForDiscriminator() {
        boolean shouldNegateCondition = this.shouldNegateCondition();
        if (this.myType instanceof JSBooleanLiteralTypeImpl) {
            Boolean literal = ((JSBooleanLiteralTypeImpl)this.myType).getLiteral();
            boolean negate = literal == Boolean.TRUE && shouldNegateCondition || literal == Boolean.FALSE && !shouldNegateCondition;
            String template = "%s." + this.myDiscriminatedPropertyName;
            String string = negate ? "!(" + template + ")" : template;
            if (string == null) {
                TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = "%s." + this.myDiscriminatedPropertyName + (shouldNegateCondition ? " !==" : " ===") + " %s";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean shouldNegateCondition() {
        return this.myIsNegative && this.mySurroundKind != TypeGuardSurroundKind.Or || !this.myIsNegative && this.mySurroundKind == TypeGuardSurroundKind.Or;
    }

    @NotNull
    private String computeTemplateForNullable() {
        if (!this.myAllowSimplifyForNullable) {
            String string = this.shouldNegateCondition() ? "%s != null" : "%s == null";
            if (string == null) {
                TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = this.shouldNegateCondition() ? "%s" : "!(%s)";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private String computeTypeOfOrInstanceOfTemplate(String typeName) {
        String string = this.shouldNegateCondition() ? (this.isTypeOfMember(typeName) ? myTypeOfNegativeTemplate : "!(%s instanceof %s)") : (this.isTypeOfMember(typeName) ? myTypeOfTemplate : myInstanceOfTemplate);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private String createGuardTextDescription() {
        PsiElement element = this.myStartElement.getElement();
        if (element == null) {
            if ("" == null) {
                TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(26);
            }
            return "";
        }
        boolean isTypeOf = this.isTypeOfMember(this.myName);
        String string = String.format(StringUtil.replace((String)StringUtil.replace((String)this.getTemplate(this.myName), (String)"$SELECTION$", (String)"..."), (String)"$END$", (String)""), element.getText(), isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(this.myName) : this.myName);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"typescript.insert.type.guard.fix.family", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surroundKind";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeofWrapType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortenedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplate";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateForDiscriminator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateForNullable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTypeOfOrInstanceOfTemplate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardTextDescription";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOfMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

