/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentAction
extends TypeScriptCompileAllAction {
    public TypeScriptCompileCurrentAction() {
        super(JSBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.current.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1);
    }

    public TypeScriptCompileCurrentAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    private static VirtualFile getCurrentFile(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @Override
    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptCompileCurrentAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    @Nullable
    protected Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project project, @Nullable DataContext context) {
        if (project == null) {
            return null;
        }
        VirtualFile configFile = this.getConfigFile(context);
        if (configFile != null) {
            return indicator -> {
                TypeScriptConfig config2 = (TypeScriptConfig)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> TypeScriptConfigService.Provider.parseConfigFile(project, configFile));
                if (config2 == null) {
                    return;
                }
                TypeScriptCompilerService compilerService = this.getServiceForConfig(project, configFile);
                if (compilerService == null) {
                    return;
                }
                LinkedHashSet infos = ContainerUtil.newLinkedHashSet();
                this.runBeforeStartingCompile(project, (ProgressIndicator)indicator, compilerService);
                TypeScriptServiceCommandClean command = new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(config2));
                compilerService.sendCleanCommandToCompiler(command);
                this.compileConfig((ProgressIndicator)indicator, compilerService, config2, infos);
                this.logErrors(project, (Collection<JSAnnotationError>)infos);
            };
        }
        VirtualFile[] files = this.getFiles(project, context);
        return indicator -> this.runCompile(project, (ProgressIndicator)indicator, files);
    }

    @Override
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        if (project == null) {
            return;
        }
        if (files == null) {
            return;
        }
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                index.iterateContentUnderDirectory(file2, descendant -> {
                    if (!descendant.isDirectory() && TypeScriptCompilerSettings.acceptFileType(descendant.getFileType())) {
                        return processor.process((Object)descendant);
                    }
                    return true;
                });
                continue;
            }
            if (!processor.process((Object)file2)) break;
        }
    }

    @Nullable
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        VirtualFile file2 = TypeScriptCompileCurrentAction.getCurrentFile(dataContext);
        if (file2 != null) {
            return new VirtualFile[]{file2};
        }
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
    }

    @Nullable
    public static VirtualFile getTypeScriptConfigVirtualFile(@Nullable DataContext context) {
        if (context == null) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 == null) {
            return null;
        }
        return "tsconfig.json".equals(file2.getName()) ? file2 : null;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptCompileCurrentAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile configVirtualFile = this.getConfigFile(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(configVirtualFile != null);
    }

    @Nullable
    protected VirtualFile getConfigFile(@Nullable DataContext context) {
        return TypeScriptCompileCurrentAction.getTypeScriptConfigVirtualFile(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileCurrentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseOnlyConfigs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

