/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.inspection.TypescriptRemoveTypeDeclarationQuickFix;
import com.intellij.lang.typescript.inspection.TypescriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptExplicitMemberTypeInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public boolean myPreferExplicitLocalVariableTypes;
    public boolean myPreferExplicitReturnTypes;

    public TypescriptExplicitMemberTypeInspection() {
        this(false, true);
    }

    public TypescriptExplicitMemberTypeInspection(boolean explicitVariableTypes, boolean explicitReturnTypes) {
        this.myPreferExplicitLocalVariableTypes = explicitVariableTypes;
        this.myPreferExplicitReturnTypes = explicitReturnTypes;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.variables.option", (Object[])new Object[0]), "myPreferExplicitLocalVariableTypes");
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.functions.option", (Object[])new Object[0]), "myPreferExplicitReturnTypes");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDestructuringElement(JSDestructuringElement destructuringElement) {
                this.visitNode((JSElement)destructuringElement, (PsiElement)destructuringElement.getTarget(), TypescriptExplicitMemberTypeInspection.this.myPreferExplicitLocalVariableTypes);
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitNode((JSElement)node, node.getNameIdentifier(), TypescriptExplicitMemberTypeInspection.this.myPreferExplicitLocalVariableTypes);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitNode((JSElement)node, node.getNameIdentifier(), TypescriptExplicitMemberTypeInspection.this.myPreferExplicitReturnTypes);
            }

            private void visitNode(@NotNull JSElement node, PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!TypescriptExplicitMemberTypeInspection.isSupportedDialect(node)) {
                    return;
                }
                if (ErrorUtil.containsError((PsiElement)node)) {
                    return;
                }
                this.inspectForRedundantTypeDeclaration(node, preferExplicitTypes);
                this.inspectForMissingDeclaration(node, elementToHighlight, preferExplicitTypes);
            }

            private void inspectForMissingDeclaration(@NotNull JSElement node, @Nullable PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (elementToHighlight == null) {
                    return;
                }
                if (TypeScriptPsiUtil.returnTypeAnnotationForbidden(node)) {
                    return;
                }
                if (TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement(node) == null) {
                    ProblemHighlightType highlightType;
                    JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)node);
                    if (inferredType == null || inferredType instanceof JSUniqueSymbolTypeImpl) {
                        return;
                    }
                    ProblemHighlightType problemHighlightType = highlightType = preferExplicitTypes ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                    if (holder.isOnTheFly() || preferExplicitTypes) {
                        holder.registerProblem(elementToHighlight, JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]), highlightType, new LocalQuickFix[]{new TypescriptSpecifyTypeExplicitlyQuickFix()});
                    }
                }
            }

            private void inspectForRedundantTypeDeclaration(@NotNull JSElement declarationOwner, boolean preferExplicitTypes) {
                ProblemHighlightType highlightType;
                JSElement declarationElement;
                if (declarationOwner == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((declarationElement = TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement(declarationOwner)) == null) {
                    return;
                }
                boolean isRedundant = !preferExplicitTypes && TypescriptExplicitMemberTypeInspection.isRedundantDeclaration(declarationOwner);
                LocalQuickFix[] quickFixes = new LocalQuickFix[]{new TypescriptRemoveTypeDeclarationQuickFix()};
                String message = JSBundle.message((String)(isRedundant ? "typescript.redundant.declaration" : "typescript.remove.type.declaration"), (Object[])new Object[0]);
                ProblemHighlightType problemHighlightType = highlightType = isRedundant ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                if (isRedundant || holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)declarationElement, message, highlightType, quickFixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationOwner";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForMissingDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForRedundantTypeDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static boolean isSupportedDialect(@NotNull JSElement node) {
        DialectOptionHolder dialect;
        if (node == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(1);
        }
        return (dialect = DialectDetector.dialectOfElement((PsiElement)node)) != null && dialect.isTypeScript;
    }

    private static boolean isRedundantDeclaration(@NotNull JSElement declarationOwner) {
        JSType typeFromDeclaration;
        if (declarationOwner == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(2);
        }
        if ((typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(declarationOwner)) instanceof JSUniqueSymbolTypeImpl) {
            return false;
        }
        return TypescriptExplicitMemberTypeInspection.isRedundantDeclaration(TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)declarationOwner), typeFromDeclaration);
    }

    private static boolean isRedundantDeclaration(@Nullable JSType inferredType, @Nullable JSType declaredType) {
        inferredType = JSTypeUtils.getValuableType(inferredType);
        return (declaredType = JSTypeUtils.getValuableType(declaredType)) != null && inferredType != null && !JSTypeCastUtil.isAlwaysAssignableType(declaredType) && !JSTypeCastUtil.isAlwaysAssignableType(inferredType) && TypescriptExplicitMemberTypeInspection.isEquivalent(inferredType, declaredType);
    }

    private static boolean isEquivalent(@NotNull JSType inferredType, @NotNull JSType declaredType) {
        TypeScriptEnum ownEnum;
        JSResolvedTypeInfo resolvedDeclaredType;
        JSResolvedTypeInfo resolvedInferredType;
        if (inferredType == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(3);
        }
        if (declaredType == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(4);
        }
        if (inferredType.isEquivalentTo(declaredType, new ProcessingContext())) {
            return true;
        }
        if (inferredType instanceof JSStringLiteralTypeImpl && declaredType instanceof JSStringType && !(declaredType instanceof JSStringLiteralTypeImpl)) {
            return true;
        }
        if (inferredType instanceof JSNumberLiteralTypeImpl && declaredType instanceof JSNumberType && !(declaredType instanceof JSNumberLiteralTypeImpl)) {
            return true;
        }
        if (inferredType instanceof JSBooleanLiteralTypeImpl && declaredType instanceof JSBooleanType && !(declaredType instanceof JSBooleanLiteralTypeImpl)) {
            return true;
        }
        return inferredType instanceof JSResolvableType && declaredType instanceof JSResolvableType && (resolvedInferredType = ((JSResolvableType)inferredType).resolveType()) != null && resolvedInferredType.isEnumLiteral() && (resolvedDeclaredType = ((JSResolvableType)declaredType).resolveType()) != null && !resolvedDeclaredType.isEnumLiteral() && resolvedDeclaredType.isEnum() && (ownEnum = (TypeScriptEnum)JSUtils.getMemberContainingClass((PsiElement)resolvedInferredType.getDeclarationOfType(TypeScriptEnumField.class))) != null && Objects.equals(resolvedDeclaredType.getDeclarationOfType(TypeScriptEnum.class), ownEnum);
    }

    @Nullable
    public static JSElement getTypeDeclarationElement(@NotNull JSElement element) {
        if (element == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(5);
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return (JSElement)((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return (JSElement)((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Nullable
    public static JSType getInferredType(@NotNull PsiElement element) {
        if (element == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(6);
        }
        return TypeFromUsageDetector.detectTypeFromUsage(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDeclarationElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

