/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspection.TypescriptExplicitMemberTypeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptSpecifyTypeExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]);
        if (string == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSElement element;
        if (project == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), (Class[])new Class[]{JSTypeDeclarationOwner.class, JSFunction.class})) == null || TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement(element) != null) {
            return;
        }
        JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)element);
        if (inferredType == null) {
            return;
        }
        inferredType = inferredType.transformTypeHierarchy(TypescriptSpecifyTypeExplicitlyQuickFix::getTypeWithEnforcedLiteralStrictness);
        String newTypeStr = JSVariablesWithInitializerPredicate.formatType(inferredType, (PsiElement)element);
        JSRefactoringUtil.setType(element, newTypeStr);
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSType getTypeWithEnforcedLiteralStrictness(@Nullable JSType t) {
        JSResolvedTypeInfo resolvedType;
        if (t instanceof JSLiteralType && ((JSLiteralType)t).canBeWidened()) {
            return ((JSLiteralType)t).copyWithCanBeWidened(false);
        }
        if (t instanceof JSResolvableType && ((JSResolvableType)t).canBeWidened() && (resolvedType = ((JSResolvableType)t).resolveType()) != null && resolvedType.isEnumLiteral()) {
            return ((JSResolvableType)t).copyWithCanBeWidened(false);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

