/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.validation.TypeScriptTypeInspectionVisitor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptValidateTypesInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptValidateTypesInspection.calcShortNameFromClass(TypeScriptValidateTypesInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.validate.types.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        TypeScriptAnnotatorCheckerProvider provider2 = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        if (!holder.isOnTheFly() && provider2.skipErrors()) {
            JSElementVisitor jSElementVisitor = new JSElementVisitor();
            if (jSElementVisitor == null) {
                TypeScriptValidateTypesInspection.$$$reportNull$$$0(2);
            }
            return jSElementVisitor;
        }
        TypeScriptTypeInspectionVisitor typeScriptTypeInspectionVisitor = new TypeScriptTypeInspectionVisitor(holder, provider2){

            @Override
            protected boolean isAcceptable(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.isTypeScript(element)) {
                    return false;
                }
                if (element instanceof JSCallExpression) {
                    element = ((JSCallExpression)element).getMethodExpression();
                }
                return !(element instanceof JSReferenceExpression) || TypeScriptUtil.resolveIsStrict((JSReferenceExpression)element);
            }

            public void visitJSReferenceList(JSReferenceList referenceList) {
                if (!this.isAcceptable((PsiElement)referenceList)) {
                    return;
                }
                JSClass jsClass = (JSClass)referenceList.getParent();
                boolean isExtends = jsClass.getExtendsList() == referenceList;
                for (Pair pair : referenceList.getResolvedExpressions()) {
                    JSExpression expr = ((JSReferenceListMember)pair.first).getExpression();
                    Collection second = (Collection)pair.getSecond();
                    if (!second.isEmpty()) continue;
                    this.checkNotResolvedReferenceListExpression(jsClass, expr, isExtends);
                }
            }

            private void checkNotResolvedReferenceListExpression(@NotNull JSClass jsClass, @NotNull JSExpression expression, boolean isExtends) {
                if (jsClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!jsClass.isInterface() && isExtends) {
                    ES6ReferenceListImpl.ClassExpressionResolve resolveInfo = ES6ReferenceListImpl.resolveExpression((PsiElement)expression);
                    if (resolveInfo.constructorError == ES6ReferenceList.Errors.CIRCLE) {
                        this.getTypeChecker((PsiElement)expression).registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.CIRCLE.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                        return;
                    }
                    JSType type = (JSType)ContainerUtil.getFirstItem(resolveInfo.types);
                    if (type == null || type instanceof JSNullType || type instanceof JSGenericParameterImpl) {
                        return;
                    }
                    ES6ReferenceList.Errors errorType = resolveInfo.constructorError;
                    if (errorType == null || errorType == ES6ReferenceList.Errors.NO_CONSTRUCTOR) {
                        this.getTypeChecker((PsiElement)expression).registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.NO_CONSTRUCTOR.getString(), (Object[])new Object[]{type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    } else if (errorType == ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS || errorType == ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES) {
                        this.getTypeChecker((PsiElement)expression).registerProblem((PsiElement)expression, JSBundle.message((String)errorType.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    } else if (errorType == ES6ReferenceList.Errors.NO_ERROR) {
                        JSType returnType;
                        JSType item = (JSType)ContainerUtil.getFirstItem(resolveInfo.types);
                        if (item instanceof JSFunctionTypeImpl && (returnType = JSTypeUtils.getNewOrReturnType(item, true)) instanceof JSRecordType) {
                            return;
                        }
                        assert (item != null);
                        this.getTypeChecker((PsiElement)expression).registerProblem((PsiElement)expression, JSBundle.message((String)ES6ReferenceList.Errors.IS_NO_CLASS.getString(), (Object[])new Object[]{item.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateTypesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAcceptable";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNotResolvedReferenceListExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (typeScriptTypeInspectionVisitor == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(3);
        }
        return typeScriptTypeInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/inspections/TypeScriptValidateTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

