/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptExtractNamedTypeHandler
implements RefactoringActionHandler {
    @NotNull
    private final JSIntroduceTargetChooser<JSTypeDeclaration> myTypeChooser;
    @NotNull
    private final ReplaceAllChooser myReplaceAllChooser;
    protected static final String DEFAULT_NAME = "Created";

    public TypeScriptExtractNamedTypeHandler(@NotNull JSIntroduceTargetChooser<JSTypeDeclaration> typeChooser, @NotNull ReplaceAllChooser chooser) {
        if (typeChooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(0);
        }
        if (chooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(1);
        }
        this.myTypeChooser = typeChooser;
        this.myReplaceAllChooser = chooser;
    }

    public TypeScriptExtractNamedTypeHandler() {
        this(IntroduceTargetChooser::showChooser, TypeScriptExtractNamedTypeHandler::showOccurrencesChooser);
    }

    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(3);
        }
        return !ContainerUtil.isEmpty(this.getCandidates(editor, file2));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(8);
        }
        List<Candidate> types = this.getCandidates(editor, file2);
        Consumer<Candidate> callback = selectedType -> {
            if (editor == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(41);
            }
            this.invokeForType(editor, (Candidate)selectedType);
        };
        this.chooseType(editor, types, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
    }

    private void invokeForType(@NotNull Editor editor, @NotNull Candidate target) {
        List<JSTypeDeclaration> occurrences;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(9);
        }
        if (target == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(10);
        }
        Project project = target.type.getProject();
        JSElement scope = TypeScriptExtractNamedTypeHandler.getScope(target.type);
        if (scope == null) {
            return;
        }
        List<JSTypeDeclaration> list = occurrences = target.relativeRange == null ? TypeScriptExtractNamedTypeHandler.findOccurrences(target.type, scope) : ContainerUtil.emptyList();
        if (occurrences.size() > 0) {
            Consumer<OccurrencesChooser.ReplaceChoice> callback = choice -> {
                if (editor == null) {
                    TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(39);
                }
                if (target == null) {
                    TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(40);
                }
                List toReplace = choice == OccurrencesChooser.ReplaceChoice.ALL ? occurrences : ContainerUtil.emptyList();
                this.invokeForOccurrences(project, editor, target, toReplace);
            };
            this.myReplaceAllChooser.invoke(editor, target.type, occurrences, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
        } else {
            this.invokeForOccurrences(project, editor, target, occurrences);
        }
    }

    private void invokeForOccurrences(@NotNull Project project, @NotNull Editor editor, @NotNull Candidate target, @NotNull List<JSTypeDeclaration> occurrences) {
        List nameCandidates;
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(12);
        }
        if (target == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(13);
        }
        if (occurrences == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(14);
        }
        JSElement scope = TypeScriptExtractNamedTypeHandler.getScope(target.type);
        JSTypeDeclaration firstInFile = occurrences.size() > 0 && occurrences.get(0).getTextRange().getStartOffset() < target.type.getTextRange().getStartOffset() ? occurrences.get(0) : target.type;
        PsiElement anchor = JSPsiImplUtils.findLeadingCommentOrSelf(PsiTreeUtil.findFirstParent((PsiElement)firstInFile, e -> e.getParent() == scope));
        if (scope == null || anchor == null) {
            return;
        }
        JSType jsType = TypeScriptExtractNamedTypeHandler.getJSType(target.type);
        List list = nameCandidates = jsType != null ? JSNameSuggestionsUtil.generateNamesForType(jsType, (PsiElement)scope) : ContainerUtil.emptyList();
        if (nameCandidates.isEmpty()) {
            nameCandidates = ContainerUtil.list((Object[])new String[]{JSNameSuggestionsUtil.ensureUniqueVariableName(DEFAULT_NAME, (PsiElement)scope, ContainerUtil.newHashSet(), false)});
        }
        JSClass typeDeclaration = this.buildTypeDeclaration(target);
        typeDeclaration = (JSClass)anchor.getParent().addBefore((PsiElement)typeDeclaration, anchor);
        JSChangeUtil.addWs(typeDeclaration.getParent().getNode(), typeDeclaration.getNode().getTreeNext(), "\n");
        FormatFixer.create((PsiElement)typeDeclaration, FormatFixer.Mode.Reformat).fixFormat();
        PsiElement templateRoot = PsiTreeUtil.findCommonParent((PsiElement)typeDeclaration, (PsiElement)target.type);
        if (templateRoot == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(anchor.getContainingFile());
        if (document == null) {
            return;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(templateRoot);
        String dependantVariableName = "OTHER_VARIABLE";
        String primaryVariableName = "PRIMARY_VARIABLE";
        templateBuilder.replaceElement(typeDeclaration.getNameIdentifier(), "OTHER_VARIABLE", "PRIMARY_VARIABLE", false);
        for (JSTypeDeclaration allOccurrences : occurrences) {
            if (allOccurrences == target.type) continue;
            templateBuilder.replaceElement((PsiElement)allOccurrences, "OTHER_VARIABLE", "PRIMARY_VARIABLE", false);
        }
        TextRange textRange = (TextRange)ObjectUtils.coalesce((Object)target.relativeRange, (Object)TextRange.create((int)0, (int)target.type.getTextLength()));
        templateBuilder.replaceElement((PsiElement)target.type, textRange, "PRIMARY_VARIABLE", (Expression)new VariableNode("PRIMARY_VARIABLE", TypeScriptExtractNamedTypeHandler.buildTemplateExpression(nameCandidates)), true);
        Template template = templateBuilder.buildInlineTemplate();
        template.setToReformat(false);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        BaseCreateFix.navigate(project, editor, templateRoot.getTextRange().getStartOffset(), target.type.getContainingFile().getVirtualFile());
        templateManager.startTemplate(editor, template);
    }

    @NotNull
    private JSClass buildTypeDeclaration(@NotNull Candidate aliased) {
        if (aliased == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(15);
        }
        String introducedText = aliased.relativeRange != null ? aliased.relativeRange.substring(aliased.type.getText()) : aliased.type.getText();
        JSClass jSClass = this.buildTypeDeclarationFromText(introducedText, (PsiElement)aliased.type);
        if (jSClass == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(16);
        }
        return jSClass;
    }

    @NotNull
    protected abstract JSClass buildTypeDeclarationFromText(String var1, @NotNull PsiElement var2);

    protected boolean isAcceptableType(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(17);
        }
        return !(declaration.getParent() instanceof TypeScriptInterface);
    }

    @NotNull
    private static List<JSTypeDeclaration> findOccurrences(@NotNull JSTypeDeclaration typeDeclaration, @NotNull JSElement scope) {
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(19);
        }
        ArrayList results = ContainerUtil.newArrayList();
        PsiTreeUtil.processElements((PsiElement)scope, e -> {
            if (typeDeclaration == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(38);
            }
            if (e instanceof JSTypeDeclaration && !(e.getParent() instanceof TypeScriptInterface) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)typeDeclaration)) {
                results.add((JSTypeDeclaration)e);
            }
            return true;
        });
        ArrayList arrayList = results;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    private static Expression buildTemplateExpression(final @NotNull List<String> nameCandidates) {
        if (nameCandidates == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(21);
        }
        Expression expression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult((String)nameCandidates.get(0));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return (LookupElement[])ContainerUtil.map2Array((Collection)nameCandidates, LookupElement.class, s -> LookupElementBuilder.create((String)s));
            }
        };
        if (expression == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(22);
        }
        return expression;
    }

    private void chooseType(Editor editor, final List<Candidate> candidates, final Pass<Candidate> callback) {
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            callback.pass((Object)candidates.get(0));
        } else {
            List list = ContainerUtil.map(candidates, t -> t.type);
            this.myTypeChooser.invoke(editor, list, new Pass<JSTypeDeclaration>(){

                public void pass(JSTypeDeclaration selected) {
                    callback.pass(ContainerUtil.find((Iterable)candidates, t -> t.type == selected));
                }
            }, (Function<JSTypeDeclaration, String>)((Function)declaration -> declaration.getText()));
        }
    }

    @NotNull
    private List<Candidate> getCandidates(@NotNull Editor editor, @NotNull PsiFile file2) {
        SelectionModel selectionModel;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(24);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            Candidate fromSelection = TypeScriptExtractNamedTypeHandler.findTypeInRange(file2, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            List list = fromSelection != null && this.isAcceptableType(fromSelection.type) ? ContainerUtil.list((Object[])new Candidate[]{fromSelection}) : ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<Candidate> list = this.lookUpCandidates(file2, editor.getCaretModel().getOffset());
        if (list == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    private static Candidate findTypeInRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(27);
        }
        if (range == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(28);
        }
        JSTypeDeclaration startElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, range.getStartOffset(), true);
        JSTypeDeclaration endElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, range.getEndOffset(), false);
        if (startElement == null || endElement == null) {
            return null;
        }
        startElement = TypeScriptExtractNamedTypeHandler.findTopmost(startElement, JSTypeDeclaration.class, (Condition<PsiElement>)((Condition)element -> {
            if (range == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(37);
            }
            return range.contains(element.getTextRange());
        }));
        endElement = TypeScriptExtractNamedTypeHandler.findTopmost(endElement, JSTypeDeclaration.class, (Condition<PsiElement>)((Condition)element -> {
            if (range == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(36);
            }
            return range.contains(element.getTextRange());
        }));
        if (startElement == null || endElement == null) {
            return null;
        }
        if (startElement == endElement && range.contains(startElement.getTextRange())) {
            return new Candidate(startElement, null);
        }
        if (startElement.getParent() == endElement.getParent() && startElement.getParent() instanceof TypeScriptUnionOrIntersectionType) {
            PsiElement parent = startElement.getParent();
            TextRange meaningfulRange = new TextRange(startElement.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset());
            return parent.getTextRange().contains(meaningfulRange) ? new Candidate((JSTypeDeclaration)parent, meaningfulRange.shiftLeft(parent.getTextRange().getStartOffset())) : null;
        }
        return null;
    }

    @NotNull
    private List<Candidate> lookUpCandidates(@NotNull PsiFile file2, int offset) {
        JSTypeDeclaration current;
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(29);
        }
        if ((current = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, offset, true)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList types = ContainerUtil.newArrayList();
        while (current != null) {
            Candidate last = (Candidate)ContainerUtil.getLastItem((List)types);
            if ((last == null || !current.getTextRange().equals((Object)last.type.getTextRange())) && this.isAcceptableType(current)) {
                types.add(new Candidate(current, null));
            }
            if (!((current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class)) instanceof TypeScriptParenthesizedType)) continue;
            current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class);
        }
        ArrayList arrayList = types;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @Nullable
    private static <T extends PsiElement> T findTopmost(@NotNull T element, Class<T> clazz, Condition<PsiElement> condition) {
        if (element == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(32);
        }
        if (!condition.value(element)) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType(element, clazz);
        while (parent != null && condition.value((Object)parent)) {
            element = parent;
            parent = PsiTreeUtil.getParentOfType(element, clazz);
        }
        return element;
    }

    @Nullable
    private static JSTypeDeclaration findTypeElementAt(@NotNull PsiFile file2, int offset, boolean forward) {
        PsiElement element;
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(33);
        }
        if ((element = file2.findElementAt(offset == file2.getTextLength() && !forward && offset > 0 ? offset - 1 : offset)) == null || !DialectDetector.isTypeScript(element)) {
            return null;
        }
        if (!forward) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        while (element != null && (element instanceof PsiWhiteSpace || element instanceof PsiComment || element.getNode().getElementType() == JSTokenTypes.LPAR || element.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, JSTypeDeclaration.class);
    }

    @Nullable
    private static JSElement getScope(@NotNull JSTypeDeclaration typeElement) {
        if (typeElement == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(34);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)typeElement, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class, TypeScriptModule.class});
    }

    @Nullable
    private static JSType getJSType(@NotNull JSTypeDeclaration typeDeclaration) {
        PsiElement owner;
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(35);
        }
        return (owner = (PsiElement)ObjectUtils.tryCast((Object)typeDeclaration.getParent(), JSTypeDeclarationOwner.class)) != null ? ((JSTypeDeclarationOwner)owner).getType() : null;
    }

    private static <T> Pass<T> writeCallback(final Consumer<T> callback) {
        return new Pass<T>(){

            public void pass(T t) {
                ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> callback.accept(t)));
            }
        };
    }

    private static void showOccurrencesChooser(Editor editor, JSTypeDeclaration main, List<JSTypeDeclaration> occurrences, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)main, occurrences, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 23: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: 
            case 24: 
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 13: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliased";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 18: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
            case 28: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeDeclaration";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTemplateExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "lookUpCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeForType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeForOccurrences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeDeclaration";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTypeInRange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lookUpCandidates";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findTopmost";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findTypeElementAt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getJSType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTypeInRange$7";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTypeInRange$6";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOccurrences$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeForType$1";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Candidate {
        @NotNull
        public final JSTypeDeclaration type;
        @Nullable
        public final TextRange relativeRange;

        public Candidate(@NotNull JSTypeDeclaration type, @Nullable TextRange relativeRange) {
            if (type == null) {
                Candidate.$$$reportNull$$$0(0);
            }
            this.type = type;
            this.relativeRange = relativeRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$Candidate", "<init>"));
        }
    }

    public static interface ReplaceAllChooser {
        public void invoke(Editor var1, JSTypeDeclaration var2, List<JSTypeDeclaration> var3, Pass<OccurrencesChooser.ReplaceChoice> var4);
    }
}

