/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeHelper
extends JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new TypeScriptTypeHelper();

    private TypeScriptTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    @Override
    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(1);
        }
        if (rOpType instanceof JSFunctionTypeImpl || rOpType instanceof JSArrayTypeImpl) {
            JSTypeCastUtil.AssignableResult result2 = this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext);
            if (result2.isStrict()) {
                return result2.isAssignable();
            }
        } else if (rOpType instanceof JSGenericTypeImpl) {
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            JSResolvedTypeId lKey = lOpType.getResolvedTypeId();
            JSResolvedTypeId rKey = ((JSGenericTypeImpl)rOpType).getType().getResolvedTypeId();
            return JSRecursiveTypeUtil.computeWithRecursiveTypes(lKey, rKey, processingContext, ctx -> {
                if (lOpType == null) {
                    TypeScriptTypeHelper.$$$reportNull$$$0(14);
                }
                if (rOpType == null) {
                    TypeScriptTypeHelper.$$$reportNull$$$0(15);
                }
                return lOpType.isDirectlyAssignableType((JSType)TypeScriptTypeParser.buildResolvedType(rOpType), ctx);
            }, Boolean.valueOf(true));
        }
        return super.isAssignableToNamedType(lOpType, rOpType, processingContext);
    }

    @Override
    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @Nullable ProcessingContext processingContext) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(2);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(3);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(lOpType, rOpType, processingContext, ctx -> {
            JSTypeCastUtil.AssignableResult assignableResult;
            if (lOpType == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(12);
            }
            if (rOpType == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(13);
            }
            if ((assignableResult = TypeScriptTypeHelper.areNamedTypesClassAssignable(lOpType, rOpType)).isStrict()) {
                return assignableResult.isAssignable();
            }
            JSRecordType lOpResolvedType = lOpType.asRecordType();
            if (rOpType instanceof JSPrimitiveFunctionType && rOpType.isJavaScript() && TypeScriptTypeHelper.checkTypeContainsCallSignaturesWithoutProperties(lOpResolvedType)) {
                return true;
            }
            JSRecordType rOpResolvedType = rOpType.asRecordType();
            return lOpResolvedType.isDirectlyAssignableType((JSType)rOpResolvedType, ctx);
        }, Boolean.valueOf(true));
    }

    private static boolean checkTypeContainsCallSignaturesWithoutProperties(@NotNull JSRecordType type) {
        if (type == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(4);
        }
        return !type.hasProperties() && !type.getCallSignatures().isEmpty();
    }

    @NotNull
    public static JSTypeCastUtil.AssignableResult areNamedTypesClassAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(5);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(6);
        }
        Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(lOpType);
        Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rOpType);
        if (lOpElements.isEmpty() || rOpElements.isEmpty()) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(7);
            }
            return assignableResult;
        }
        boolean leftEnum = false;
        boolean rightEnum = false;
        for (PsiElement psiElement : lOpElements) {
            if (psiElement instanceof TypeScriptTypeAlias) continue;
            for (PsiElement psiElement2 : rOpElements) {
                if (psiElement2 instanceof TypeScriptTypeAlias) continue;
                if (psiElement == psiElement2 || psiElement instanceof JSClass && psiElement2 instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)psiElement2, (JSClass)psiElement, false)) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        TypeScriptTypeHelper.$$$reportNull$$$0(8);
                    }
                    return assignableResult;
                }
                leftEnum = leftEnum || psiElement instanceof TypeScriptEnum;
                boolean bl = rightEnum = rightEnum || psiElement2 instanceof TypeScriptEnum;
                if ((!leftEnum || !(rOpType instanceof JSNumberType)) && (!rightEnum || !(lOpType instanceof JSNumberType))) continue;
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    TypeScriptTypeHelper.$$$reportNull$$$0(9);
                }
                return assignableResult;
            }
        }
        if (leftEnum && rightEnum) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(10);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(11);
        }
        return assignableResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "areNamedTypesClassAssignable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToNamedType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesAssignable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeContainsCallSignaturesWithoutProperties";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesClassAssignable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$areNamedTypesAssignable$1";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAssignableToNamedType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

