/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MatchOptions
implements JDOMExternalizable {
    private final Map<String, MatchVariableConstraint> variableConstraints;
    private boolean looseMatching;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private boolean resultIsContextMatch;
    private FileType myFileType;
    private Language myDialect;
    private SearchScope scope;
    private String pattern;
    private String myPatternContext;
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    @NonNls
    private static final String LOOSE_MATCHING_ATTRIBUTE_NAME = "loose";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    private static final String CASESENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public MatchOptions() {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        this.looseMatching = true;
        this.resultIsContextMatch = false;
        this.myFileType = null;
        this.myDialect = null;
        this.pattern = "";
    }

    MatchOptions(MatchOptions options) {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>(options.variableConstraints.size());
        options.variableConstraints.forEach((key, value) -> this.variableConstraints.put((String)key, value.copy()));
        this.looseMatching = options.looseMatching;
        this.recursiveSearch = options.recursiveSearch;
        this.caseSensitiveMatch = options.caseSensitiveMatch;
        this.resultIsContextMatch = options.resultIsContextMatch;
        this.myFileType = options.myFileType;
        this.myDialect = options.myDialect;
        this.scope = options.scope;
        this.pattern = options.pattern;
        this.myPatternContext = options.myPatternContext;
    }

    public MatchOptions copy() {
        return new MatchOptions(this);
    }

    public void addVariableConstraint(@NotNull MatchVariableConstraint constraint) {
        if (constraint == null) {
            MatchOptions.$$$reportNull$$$0(0);
        }
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public boolean hasVariableConstraints() {
        return !this.variableConstraints.isEmpty();
    }

    public void clearVariableConstraints() {
        this.variableConstraints.clear();
    }

    public void retainVariableConstraints(Collection<String> names) {
        if (this.variableConstraints.isEmpty()) {
            return;
        }
        THashSet nameSet = new THashSet(names);
        Iterator<String> iterator = this.variableConstraints.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (nameSet.contains((Object)key)) continue;
            iterator.remove();
        }
    }

    public MatchVariableConstraint getVariableConstraint(String name) {
        return this.variableConstraints.get(name);
    }

    public Set<String> getVariableConstraintNames() {
        return Collections.unmodifiableSet(this.variableConstraints.keySet());
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        return "match options:\npattern:\n" + this.pattern + "\nscope:\n" + (this.scope != null ? this.scope.toString() : "undefined scope") + "\nrecursive: " + this.recursiveSearch + "\ncase sensitive: " + this.caseSensitiveMatch + "\nloose: " + this.looseMatching;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(@NotNull String text) {
        if (text == null) {
            MatchOptions.$$$reportNull$$$0(1);
        }
        this.pattern = text;
    }

    public String getSearchPattern() {
        return this.pattern;
    }

    public void fillSearchCriteria(String criteria) {
        StringToConstraintsTransformer.transformCriteria(criteria, this);
    }

    public boolean isResultIsContextMatch() {
        return this.resultIsContextMatch;
    }

    public void setResultIsContextMatch(boolean resultIsContextMatch) {
        this.resultIsContextMatch = resultIsContextMatch;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void writeExternal(Element element) {
        element.setAttribute(TEXT_ATTRIBUTE_NAME, this.pattern);
        if (!this.looseMatching) {
            element.setAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME, String.valueOf(false));
        }
        element.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        element.setAttribute(CASESENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        if (this.myFileType != null) {
            element.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        }
        if (this.myDialect != null) {
            element.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
            if (matchVariableConstraint.isArtificial()) continue;
            Element infoElement = new Element(CONSTRAINT_TAG_NAME);
            element.addContent(infoElement);
            matchVariableConstraint.writeExternal(infoElement);
        }
    }

    public void readExternal(Element element) {
        this.pattern = element.getAttribute(TEXT_ATTRIBUTE_NAME).getValue();
        Attribute attr = element.getAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME);
        if (attr != null) {
            try {
                this.looseMatching = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {}
        } else {
            this.looseMatching = true;
        }
        if ((attr = element.getAttribute(RECURSIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.recursiveSearch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(CASESENSITIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.caseSensitiveMatch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(FILE_TYPE_ATTR_NAME)) != null) {
            this.myFileType = MatchOptions.getFileTypeByName(attr.getValue());
        }
        if ((attr = element.getAttribute(DIALECT_ATTR_NAME)) != null) {
            this.myDialect = Language.findLanguageByID((String)attr.getValue());
        }
        for (Element element1 : element.getChildren(CONSTRAINT_TAG_NAME)) {
            MatchVariableConstraint constraint = new MatchVariableConstraint();
            constraint.readExternal(element1);
            this.addVariableConstraint(constraint);
        }
    }

    private static FileType getFileTypeByName(String value) {
        if (value != null) {
            for (FileType type : StructuralSearchUtil.getSuitableFileTypes()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (!this.pattern.equals(matchOptions.pattern)) {
            return false;
        }
        if (!this.variableConstraints.equals(matchOptions.variableConstraints)) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (this.myDialect != null ? !this.myDialect.equals(matchOptions.myDialect) : matchOptions.myDialect != null) {
            return false;
        }
        return !(this.myPatternContext != null ? !this.myPatternContext.equals(matchOptions.myPatternContext) : matchOptions.myPatternContext != null);
    }

    public int hashCode() {
        int result = this.looseMatching ? 1 : 0;
        result = 29 * result + (this.recursiveSearch ? 1 : 0);
        result = 29 * result + (this.caseSensitiveMatch ? 1 : 0);
        result = 29 * result + this.pattern.hashCode();
        result = 29 * result + this.variableConstraints.hashCode();
        if (this.myFileType != null) {
            result = 29 * result + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result = 29 * result + this.myDialect.hashCode();
        }
        return result;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        if (this.myFileType == null) {
            this.myFileType = StructuralSearchUtil.getDefaultFileType();
        }
        return this.myFileType;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public String getPatternContext() {
        return this.myPatternContext;
    }

    public void setPatternContext(String patternContext) {
        this.myPatternContext = patternContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONSTRAINT_TAG_NAME;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEXT_ATTRIBUTE_NAME;
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/MatchOptions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariableConstraint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSearchPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

