/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        new XmlCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(1);
        }
        XmlMatchingVisitor xmlMatchingVisitor = new XmlMatchingVisitor(globalVisitor);
        if (xmlMatchingVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return xmlMatchingVisitor;
    }

    @Override
    public boolean isIdentifier(PsiElement element) {
        return element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> {
            if (element instanceof XmlText) {
                PsiElement child = element.getFirstChild();
                return child == element.getLastChild() && child instanceof PsiWhiteSpace;
            }
            return element instanceof PsiWhiteSpace || element instanceof PsiErrorElement;
        };
        if (nodeFilter == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return nodeFilter;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        XmlCompiledPattern xmlCompiledPattern = new XmlCompiledPattern();
        if (xmlCompiledPattern == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return xmlCompiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return language instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project, boolean physical) {
        if (text == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (project == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String text1 = context == PatternTreeContext.File ? text : "<QQQ>" + text + "</QQQ>";
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy." + ext, fileType, (CharSequence)text1, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)fileFromText).getDocument());
        if (context == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{document};
            if (psiElementArray == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }
        XmlTagChild[] xmlTagChildArray = document.getRootTag().getValue().getChildren();
        if (xmlTagChildArray == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return xmlTagChildArray;
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        if (XmlContextType.class == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public FileType detectFileType(@NotNull PsiElement context) {
        Language contextLanguage;
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        PsiFile file = context instanceof PsiFile ? (PsiFile)context : context.getContainingFile();
        Language language = contextLanguage = context instanceof PsiFile ? null : context.getLanguage();
        if (file.getLanguage() == StdLanguages.HTML || file.getFileType() == StdFileTypes.JSP && contextLanguage == StdLanguages.HTML) {
            LanguageFileType languageFileType = StdFileTypes.HTML;
            if (languageFileType == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(14);
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        return languageFileType;
    }

    @Override
    public void checkReplacementPattern(Project project, ReplaceOptions options) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(16);
        }
        return new MyReplaceHandler(context);
    }

    private static void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent, ReplacementContext context) {
        PsiElement[] statements = ReplacerUtil.createTreeForReplacement(replacementToMake, PatternTreeContext.Block, context);
        if (statements.length > 1) {
            elementParent.addRangeBefore(statements[0], statements[statements.length - 1], elementToReplace);
        } else if (statements.length == 1) {
            PsiElement replacement = statements[0];
            Replacer.handleComments(elementToReplace, replacement, info);
            try {
                elementParent.addBefore(replacement, elementToReplace);
            }
            catch (IncorrectOperationException e) {
                elementToReplace.replace(replacement);
            }
        }
        int matchSize = info.getMatchesCount();
        for (int i = 0; i < matchSize; ++i) {
            PsiElement next;
            PsiElement element = info.getMatch(i);
            if (element == null) continue;
            PsiElement firstToDelete = element;
            PsiElement lastToDelete = element;
            PsiElement prevSibling = element.getPrevSibling();
            PsiElement nextSibling = element.getNextSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                firstToDelete = prevSibling;
            } else if (prevSibling == null && nextSibling instanceof PsiWhiteSpace) {
                lastToDelete = nextSibling;
            }
            if (nextSibling instanceof XmlText && i + 1 < matchSize && (next = info.getMatch(i + 1)) != null && next == nextSibling.getNextSibling()) {
                lastToDelete = nextSibling;
            }
            element.getParent().deleteChildRange(firstToDelete, lastToDelete);
        }
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return XmlPredefinedConfigurations.createPredefinedTemplates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextTypeClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XmlPredefinedConfigurations {
        private static final String HTML_XML = SSRBundle.message("xml_html.category", new Object[0]);

        private XmlPredefinedConfigurations() {
        }

        private static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo("xml tag", "<'a/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute", "<'_tag 'attribute=\"'_value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute", "<'_tag 'attribute />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute value", "<'_tag '_attribute=\"'value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute value", "<'_tag '_attribute='value />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml/html tag value", "<table>'_content*</table>", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<ul> or <ol>", "<'_tag:[regex( ul|ol )] />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<li> not contained in <ul> or <ol>", "[!within( \"<ul> or <ol>\" )]<li />", HTML_XML, (FileType)StdFileTypes.HTML)};
        }
    }

    private static class MyReplaceHandler
    extends StructuralReplaceHandler {
        private final ReplacementContext myContext;

        private MyReplaceHandler(ReplacementContext context) {
            this.myContext = context;
        }

        @Override
        public void replace(ReplacementInfo info, ReplaceOptions options) {
            PsiElement[] statements;
            PsiElement elementToReplace = info.getMatch(0);
            assert (elementToReplace != null);
            PsiElement elementParent = elementToReplace.getParent();
            String replacementToMake = info.getReplacement();
            boolean listContext = elementToReplace.getParent() instanceof XmlTag;
            if (listContext) {
                XmlStructuralSearchProfile.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent, this.myContext);
            }
            if ((statements = ReplacerUtil.createTreeForReplacement(replacementToMake, PatternTreeContext.Block, this.myContext)).length > 0) {
                PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, statements, replacementToMake, elementParent);
                Replacer.handleComments(elementToReplace, replacement, info);
                elementToReplace.replace(replacement);
            } else {
                elementToReplace.delete();
            }
        }
    }
}

