/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.model.xml.components.SeamEvent;
import com.intellij.seam.model.xml.components.SeamImport;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.model.impl.DomModelImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class SeamDomModelImpl
extends DomModelImpl<SeamComponents>
implements SeamDomModel {
    private final Module myModule;
    private final NotNullLazyValue<List<SeamDomComponent>> myDomComponents;
    private final NotNullLazyValue<List<SeamImport>> myImports;
    private final NotNullLazyValue<List<SeamEvent>> myEventTypes;
    private final NotNullLazyValue<List<SeamDomFactory>> myFactories;
    private final ConcurrentMap<PsiType, List<SeamDomComponent>> myComponentsByClass;
    private final ConcurrentMap<String, List<SeamDomComponent>> myComponentsByName;

    public SeamDomModelImpl(@NotNull Module module, @NotNull DomFileElement<SeamComponents> mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (module == null) {
            SeamDomModelImpl.$$$reportNull$$$0(0);
        }
        if (mergedModel == null) {
            SeamDomModelImpl.$$$reportNull$$$0(1);
        }
        if (configFiles == null) {
            SeamDomModelImpl.$$$reportNull$$$0(2);
        }
        super(mergedModel, configFiles);
        this.myDomComponents = new NotNullLazyValue<List<SeamDomComponent>>(){

            @NotNull
            protected List<SeamDomComponent> compute() {
                ArrayList<SeamDomComponent> seamDomComponents = new ArrayList<SeamDomComponent>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamDomComponent domComponent : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamDomComponent.class)) {
                        seamDomComponents.add(domComponent);
                    }
                }
                ArrayList<SeamDomComponent> arrayList = seamDomComponents;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$1", "compute"));
            }
        };
        this.myImports = new NotNullLazyValue<List<SeamImport>>(){

            @NotNull
            protected List<SeamImport> compute() {
                ArrayList<SeamImport> seamImports = new ArrayList<SeamImport>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamImport seamImport : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamImport.class)) {
                        seamImports.add(seamImport);
                    }
                }
                ArrayList<SeamImport> arrayList = seamImports;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$2", "compute"));
            }
        };
        this.myEventTypes = new NotNullLazyValue<List<SeamEvent>>(){

            @NotNull
            protected List<SeamEvent> compute() {
                ArrayList<SeamEvent> seamEventTypes = new ArrayList<SeamEvent>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamEvent seamEventType : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamEvent.class)) {
                        seamEventTypes.add(seamEventType);
                    }
                }
                ArrayList<SeamEvent> arrayList = seamEventTypes;
                if (arrayList == null) {
                    3.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$3", "compute"));
            }
        };
        this.myFactories = new NotNullLazyValue<List<SeamDomFactory>>(){

            @NotNull
            protected List<SeamDomFactory> compute() {
                ArrayList<SeamDomFactory> factories = new ArrayList<SeamDomFactory>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamDomFactory domFactory : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamDomFactory.class)) {
                        factories.add(domFactory);
                    }
                }
                ArrayList<SeamDomFactory> arrayList = factories;
                if (arrayList == null) {
                    4.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$4", "compute"));
            }
        };
        this.myComponentsByClass = ConcurrentFactoryMap.createMap(key -> this.computeSeamComponentsByPsiType((PsiType)key));
        this.myComponentsByName = ConcurrentFactoryMap.createMap(key -> this.computeSeamComponentsByName((String)key));
        this.myModule = module;
    }

    private List<SeamDomComponent> computeSeamComponentsByName(@NotNull String componentName) {
        if (componentName == null) {
            SeamDomModelImpl.$$$reportNull$$$0(3);
        }
        ArrayList<SeamDomComponent> components = new ArrayList<SeamDomComponent>();
        for (SeamDomComponent domComponent : this.getSeamComponents()) {
            if (!componentName.equals(domComponent.getComponentName())) continue;
            components.add(domComponent);
        }
        return components;
    }

    private List<SeamDomComponent> computeSeamComponentsByPsiType(PsiType PsiType2) {
        ArrayList<SeamDomComponent> components = new ArrayList<SeamDomComponent>();
        for (SeamDomComponent domComponent : this.getSeamComponents()) {
            PsiType componentClass = domComponent.getComponentType();
            if (!PsiType2.equals(componentClass)) continue;
            components.add(domComponent);
        }
        return components;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents() {
        List list = (List)this.myDomComponents.getValue();
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents(@NotNull PsiType psiType) {
        if (psiType == null) {
            SeamDomModelImpl.$$$reportNull$$$0(5);
        }
        List list = (List)this.myComponentsByClass.get(psiType);
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents(@NotNull String componentName) {
        if (componentName == null) {
            SeamDomModelImpl.$$$reportNull$$$0(7);
        }
        List list = (List)this.myComponentsByName.get(componentName);
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamImport> getImports() {
        List list = (List)this.myImports.getValue();
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomFactory> getFactories() {
        List list = (List)this.myFactories.getValue();
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamEvent> getEvents() {
        List list = (List)this.myEventTypes.getValue();
        if (list == null) {
            SeamDomModelImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/impl/model/xml/SeamDomModelImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/impl/model/xml/SeamDomModelImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeamComponents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeSeamComponentsByName";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSeamComponents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

