/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.javaee.module.view.nodes.JavaeeClassNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamComponentNodeDescriptor
extends JavaeeClassNodeDescriptor {
    private final SeamJamComponent mySeamComponent;

    public SeamComponentNodeDescriptor(SeamJamComponent seamComponent, JavaeeNodeDescriptor parentDescriptor, Object parameters) {
        super(seamComponent.getPsiElement(), parentDescriptor, parameters);
        this.mySeamComponent = seamComponent;
    }

    public String getNewNodeText() {
        if (!this.mySeamComponent.isValid()) {
            return "";
        }
        return StringUtil.isEmptyOrSpaces((String)this.mySeamComponent.getComponentName()) ? super.getNewNodeText() : this.mySeamComponent.getComponentName();
    }

    public boolean isValid() {
        return this.mySeamComponent != null && this.mySeamComponent.isValid();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.mySeamComponent};
        if (objectArray == null) {
            SeamComponentNodeDescriptor.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public String getNewTooltip() {
        if (!this.mySeamComponent.isValid()) {
            return "";
        }
        StringBuffer tooltip = new StringBuffer();
        String name = this.mySeamComponent.getComponentName();
        PsiType psiType = this.mySeamComponent.getComponentType();
        SeamComponentScope scope = this.mySeamComponent.getComponentScope();
        List<SeamJamRole> roles = this.mySeamComponent.getRoles();
        if (name != null) {
            tooltip.append("<tr><td><strong>name:</strong></td><td>").append(name).append("</td></tr>");
        }
        if (psiType != null) {
            tooltip.append("<tr><td><strong>class:</strong></td><td>").append(psiType.getPresentableText()).append("</td></tr>");
        }
        if (scope != null) {
            tooltip.append("<tr><td><strong>scope:</strong></td><td>").append(scope.getValue()).append("</td></tr>");
        }
        if (!roles.isEmpty()) {
            tooltip.append("<tr><td valign=\"top\"><strong>roles:</strong></td><td><table>");
            for (SeamJamRole role : roles) {
                String roleName = role.getName();
                SeamComponentScope roleScope = role.getScope();
                tooltip.append("<tr><td>").append(roleName == null ? "unknown" : roleName).append("</td><td>").append(roleScope == null ? "" : roleScope.getValue()).append("</td></tr>");
            }
            tooltip.append("</table></td></tr>");
        }
        if (tooltip.length() != 0) {
            return "<html><table>" + tooltip.toString() + "</table></html>";
        }
        return super.getNewTooltip();
    }

    public JavaeeNodeDescriptor[] getChildren() {
        return JavaeeNodeDescriptor.EMPTY_ARRAY;
    }

    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + this.getNewNodeTextExt() + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        PsiClass psiClass = (PsiClass)this.getElement();
        if (psiClass == null || !psiClass.isValid()) {
            return null;
        }
        return psiClass.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/structure/SeamComponentNodeDescriptor", "getEqualityObjects"));
    }
}

