/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.MakeExternalAnnotationExplicit;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeAnnotationExternal
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Annotate Externally" == null) {
            MakeAnnotationExternal.$$$reportNull$$$0(0);
        }
        return "Annotate Externally";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner modifierListOwner;
        PsiAnnotation annotation;
        if (project == null) {
            MakeAnnotationExternal.$$$reportNull$$$0(1);
        }
        if ((annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiAnnotation.class)) != null && annotation.getQualifiedName() != null && annotation.getManager().isInProject((PsiElement)annotation) && (modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)modifierListOwner);
            if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS || virtualFile != null && ExternalAnnotationsManager.getInstance((Project)project).hasAnnotationRootsForFile(virtualFile)) {
                this.setText("Annotate externally");
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            MakeAnnotationExternal.$$$reportNull$$$0(2);
        }
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiAnnotation.class);
        assert (annotation != null);
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        assert (owner != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file, owner, externalAnnotationsManager))) {
            return;
        }
        String qualifiedName = annotation.getQualifiedName();
        assert (qualifiedName != null);
        try {
            externalAnnotationsManager.annotateExternally(owner, qualifiedName, file, annotation.getParameterList().getAttributes());
        }
        catch (ExternalAnnotationsManager.CanceledConfigurationException e) {
            return;
        }
        WriteAction.run(() -> annotation.delete());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MakeAnnotationExternal";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MakeAnnotationExternal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

