/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchFix
implements IntentionAction {
    private final PsiParameter myCatchParameter;

    public DeleteCatchFix(@NotNull PsiParameter myCatchParameter) {
        if (myCatchParameter == null) {
            DeleteCatchFix.$$$reportNull$$$0(0);
        }
        this.myCatchParameter = myCatchParameter;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter.getType()));
        if (string == null) {
            DeleteCatchFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.catch.family", new Object[0]);
        if (string == null) {
            DeleteCatchFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DeleteCatchFix.$$$reportNull$$$0(3);
        }
        return this.myCatchParameter.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myCatchParameter.getContainingFile());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            DeleteCatchFix.$$$reportNull$$$0(4);
        }
        PsiParameter psiParameter = this.myCatchParameter;
        if (psiParameter == null) {
            DeleteCatchFix.$$$reportNull$$$0(5);
        }
        return psiParameter;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiTryStatement tryStatement;
        if (project == null) {
            DeleteCatchFix.$$$reportNull$$$0(6);
        }
        if ((tryStatement = ((PsiCatchSection)this.myCatchParameter.getDeclarationScope()).getTryStatement()).getCatchBlocks().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null) {
            PsiElement firstElement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            PsiCodeBlock lastAddedStatement = null;
            if (tryBlock != null && (firstElement = tryBlock.getFirstBodyElement()) != null) {
                PsiElement tryParent = tryStatement.getParent();
                if (tryParent instanceof PsiCodeBlock) {
                    PsiElement lastBodyElement = tryBlock.getLastBodyElement();
                    assert (lastBodyElement != null) : tryBlock.getText();
                    tryParent.addRangeBefore(firstElement, lastBodyElement, (PsiElement)tryStatement);
                    for (lastAddedStatement = tryStatement.getPrevSibling(); lastAddedStatement != null && (lastAddedStatement instanceof PsiWhiteSpace || lastAddedStatement.getTextLength() == 0); lastAddedStatement = lastAddedStatement.getPrevSibling()) {
                    }
                } else {
                    tryParent.addBefore((PsiElement)tryBlock, (PsiElement)tryStatement);
                    lastAddedStatement = tryBlock;
                }
            }
            tryStatement.delete();
            if (lastAddedStatement != null) {
                editor.getCaretModel().moveToOffset(lastAddedStatement.getTextRange().getEndOffset());
            }
            return;
        }
        PsiElement catchSection = this.myCatchParameter.getParent();
        assert (catchSection instanceof PsiCatchSection) : catchSection;
        PsiElement previousElement = catchSection.getPrevSibling();
        while (previousElement instanceof PsiWhiteSpace) {
            previousElement = previousElement.getPrevSibling();
        }
        catchSection.delete();
        if (previousElement != null) {
            editor.getCaretModel().moveToOffset(previousElement.getTextRange().getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myCatchParameter";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

