/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateGetterAndSetterHandler;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateFieldOrPropertyHandler
extends GenerateMembersHandlerBase {
    private final String myAttributeName;
    private final PsiType myType;
    private final PropertyMemberType myMemberType;
    private final PsiAnnotation[] myAnnotations;

    public GenerateFieldOrPropertyHandler(String attributeName, PsiType type2, PropertyMemberType memberType, PsiAnnotation ... annotations2) {
        super("");
        this.myAttributeName = attributeName;
        this.myType = type2;
        this.myMemberType = memberType;
        this.myAnnotations = annotations2;
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        return ClassMember.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List list;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        try {
            String fieldName = this.getFieldName(aClass);
            PsiField psiField = psiElementFactory.createField(fieldName, this.myType);
            GenerationInfo[] infos = new GenerateGetterAndSetterHandler().generateMemberPrototypes(aClass, new PsiFieldMember(psiField));
            if (this.myAnnotations.length > 0) {
                PsiModifierList modifierList;
                PsiField targetMember = null;
                if (this.myMemberType == PropertyMemberType.FIELD) {
                    targetMember = psiField;
                } else {
                    for (GenerationInfo info : infos) {
                        PsiMember member = info.getPsiMember();
                        if (!(member instanceof PsiMethod) || (this.myMemberType != PropertyMemberType.GETTER || !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)member))) && (this.myMemberType != PropertyMemberType.SETTER || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)((PsiMethod)member)))) continue;
                        targetMember = member;
                        break;
                    }
                    if (targetMember == null) {
                        targetMember = this.findExistingMember(aClass, this.myMemberType);
                    }
                }
                PsiModifierList psiModifierList = modifierList = targetMember != null ? targetMember.getModifierList() : null;
                if (modifierList != null) {
                    for (PsiAnnotation annotation : this.myAnnotations) {
                        PsiAnnotation existing = modifierList.findAnnotation(annotation.getQualifiedName());
                        if (existing != null) {
                            existing.replace((PsiElement)annotation);
                            continue;
                        }
                        modifierList.addAfter((PsiElement)annotation, null);
                    }
                }
            }
            list = ContainerUtil.concat(Collections.singletonList(new PsiGenerationInfo<PsiField>(psiField)), Arrays.asList(infos));
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            List list2 = Collections.emptyList();
            if (list2 == null) {
                GenerateFieldOrPropertyHandler.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (list == null) {
            GenerateFieldOrPropertyHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public PsiMember findExistingMember(@NotNull PsiClass aClass, @NotNull PropertyMemberType memberType) {
        block7: {
            if (aClass == null) {
                GenerateFieldOrPropertyHandler.$$$reportNull$$$0(2);
            }
            if (memberType == null) {
                GenerateFieldOrPropertyHandler.$$$reportNull$$$0(3);
            }
            if (memberType == PropertyMemberType.FIELD) {
                return aClass.findFieldByName(this.getFieldName(aClass), false);
            }
            if (memberType == PropertyMemberType.GETTER) {
                try {
                    PsiMethod[] templates;
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                    PsiField field = psiElementFactory.createField(this.myAttributeName, this.myType);
                    for (PsiMethod template : templates = GetterSetterPrototypeProvider.generateGetterSetters(field, this.myMemberType == PropertyMemberType.GETTER)) {
                        PsiMethod existingMethod = aClass.findMethodBySignature(template, true);
                        if (existingMethod == null) continue;
                        return existingMethod;
                    }
                }
                catch (IncorrectOperationException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return null;
    }

    private String getFieldName(PsiClass aClass) {
        return this.myMemberType == PropertyMemberType.FIELD ? this.myAttributeName : JavaCodeStyleManager.getInstance((Project)aClass.getProject()).propertyNameToVariableName(this.myAttributeName, VariableKind.FIELD);
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMemberPrototypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

