/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertCompareToToEqualsIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(1);
        }
        CompareToResult compareToResult = CompareToResult.findCompareTo(element);
        assert (compareToResult != null);
        PsiExpression qualifier = compareToResult.getQualifier();
        PsiExpression argument = compareToResult.getArgument();
        StringBuilder text2 = new StringBuilder();
        if (!compareToResult.isEqEq()) {
            text2.append('!');
        }
        if (qualifier != null) {
            text2.append(qualifier.getText()).append('.');
        }
        text2.append("equals(").append(argument.getText()).append(')');
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(text2.toString(), null);
        PsiElement result = compareToResult.getBinaryExpression().replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(result.getTextOffset() + result.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(3);
        }
        return CompareToResult.findCompareTo(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert 'compareTo()' expression to 'equals()' call" == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(4);
        }
        return "Convert 'compareTo()' expression to 'equals()' call";
    }

    @NotNull
    public String getText() {
        if ("Convert 'compareTo()' expression to 'equals()' call (may change semantics)" == null) {
            ConvertCompareToToEqualsIntention.$$$reportNull$$$0(5);
        }
        return "Convert 'compareTo()' expression to 'equals()' call (may change semantics)";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompareToResult {
        private final PsiBinaryExpression myBinaryExpression;
        private final PsiMethodCallExpression myCompareToCall;

        private CompareToResult(PsiBinaryExpression binaryExpression, PsiMethodCallExpression compareToCall) {
            this.myBinaryExpression = binaryExpression;
            this.myCompareToCall = compareToCall;
        }

        public PsiBinaryExpression getBinaryExpression() {
            return this.myBinaryExpression;
        }

        public boolean isEqEq() {
            return JavaTokenType.EQEQ.equals(this.myBinaryExpression.getOperationTokenType());
        }

        public PsiExpression getArgument() {
            return this.myCompareToCall.getArgumentList().getExpressions()[0];
        }

        public PsiExpression getQualifier() {
            return this.myCompareToCall.getMethodExpression().getQualifierExpression();
        }

        @Nullable
        static CompareToResult findCompareTo(PsiElement element) {
            PsiMethodCallExpression compareToExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType) && !JavaTokenType.EQEQ.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (lhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)lhs;
                if (!MethodCallUtils.isCompareToCall(compareToExpression) || !ExpressionUtils.isZero(rhs)) {
                    return null;
                }
            } else if (rhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)rhs;
                if (!ExpressionUtils.isZero(lhs) || !MethodCallUtils.isCompareToCall(compareToExpression)) {
                    return null;
                }
            } else {
                return null;
            }
            return new CompareToResult(binaryExpression, compareToExpression);
        }
    }
}

