/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTrivialLambdaFix
implements LocalQuickFix {
    private final String myValue;

    public ReplaceWithTrivialLambdaFix(Object value2) {
        this.myValue = String.valueOf(value2);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.name", (Object[])new Object[]{this.myValue});
        if (string == null) {
            ReplaceWithTrivialLambdaFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            ReplaceWithTrivialLambdaFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethodReferenceExpression methodRef;
        if (project == null) {
            ReplaceWithTrivialLambdaFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            ReplaceWithTrivialLambdaFix.$$$reportNull$$$0(3);
        }
        if ((methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodReferenceExpression.class)) == null) {
            return;
        }
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true);
        if (lambdaExpression == null) {
            return;
        }
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 == null) {
            return;
        }
        body2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myValue, (PsiElement)lambdaExpression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

