/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;

public final class Member
implements MemberDescriptor {
    final String internalClassName;
    final String methodName;
    final String methodDesc;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member method = (Member)o;
        return this.internalClassName.equals(method.internalClassName) && this.methodDesc.equals(method.methodDesc) && this.methodName.equals(method.methodName);
    }

    public int hashCode() {
        int result = this.internalClassName.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.methodDesc.hashCode();
        return result;
    }

    public Member(String internalClassName, String methodName, String methodDesc) {
        this.internalClassName = internalClassName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public Member(MethodInsnNode mNode) {
        this.internalClassName = mNode.owner;
        this.methodName = mNode.name;
        this.methodDesc = mNode.desc;
    }

    @Override
    @NotNull
    public HMember hashed(@Nullable MessageDigest md) {
        HMember hMember = new HMember(this, md);
        if (hMember == null) {
            Member.$$$reportNull$$$0(0);
        }
        return hMember;
    }

    public String toString() {
        return this.internalClassName + ' ' + this.methodName + ' ' + this.methodDesc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Member", "hashed"));
    }
}

