/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ContractInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                for (StandardMethodContract contract : ControlFlowAnalyzer.getMethodContracts(method)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method, contract);
                    for (Map.Entry<PsiElement, String> entry : errors.entrySet()) {
                        PsiElement element = entry.getKey();
                        holder.registerProblem(element, entry.getValue(), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                String error;
                if (!ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method == null) {
                    return;
                }
                String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text2) && (error = ContractInspection.checkContract(method, text2)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue(null);
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)value2, error, new LocalQuickFix[0]);
                }
                this.checkMutationContract(annotation, method);
            }

            private void checkMutationContract(PsiAnnotation annotation, PsiMethod method) {
                boolean pure;
                String error;
                String mutationContract = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates");
                if (StringUtil.isNotEmpty((String)mutationContract) && (error = (pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"))) ? "Pure method cannot have mutation contract" : MutationSignature.checkSignature(mutationContract, method)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue("mutates");
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)value2, error, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            ContractInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    public static String checkContract(PsiMethod method, String text2) {
        List<StandardMethodContract> contracts2;
        try {
            contracts2 = StandardMethodContract.parseContract(text2);
        }
        catch (StandardMethodContract.ParseException e) {
            return e.getMessage();
        }
        int paramCount = method.getParameterList().getParametersCount();
        for (int i = 0; i < contracts2.size(); ++i) {
            StandardMethodContract contract = contracts2.get(i);
            if (contract.arguments.length != paramCount) {
                return "Method takes " + paramCount + " parameters, while contract clause number " + (i + 1) + " expects " + contract.arguments.length;
            }
            PsiType returnType = method.getReturnType();
            if (returnType != null && !InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue)) {
                return "Method returns " + returnType.getPresentableText() + " but the contract specifies " + (Object)((Object)contract.returnValue);
            }
            if (!method.isConstructor() || contract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) continue;
            return "Invalid contract return value for a constructor: " + (Object)((Object)contract.returnValue);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

