/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.EqClass;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DistinctPairSet
extends AbstractSet<DistinctPair> {
    private final DfaMemoryStateImpl myState;
    private final TLongHashSet myData;

    DistinctPairSet(DfaMemoryStateImpl state) {
        this.myState = state;
        this.myData = new TLongHashSet();
    }

    DistinctPairSet(DfaMemoryStateImpl state, DistinctPairSet other) {
        this.myData = new TLongHashSet(other.size());
        this.myState = state;
        other.myData.forEach(arg_0 -> ((TLongHashSet)this.myData).add(arg_0));
    }

    boolean addOrdered(int firstIndex, int secondIndex) {
        TLongHashSet toAdd = new TLongHashSet();
        toAdd.add(DistinctPairSet.createPair(firstIndex, secondIndex, true));
        for (DistinctPair pair : this) {
            if (!pair.isOrdered()) continue;
            if (pair.myFirst == secondIndex) {
                if (pair.mySecond == firstIndex || this.myData.contains(DistinctPairSet.createPair(pair.mySecond, firstIndex, true))) {
                    return false;
                }
                toAdd.add(DistinctPairSet.createPair(firstIndex, pair.mySecond, true));
                continue;
            }
            if (pair.mySecond != firstIndex) continue;
            if (this.myData.contains(DistinctPairSet.createPair(secondIndex, pair.myFirst, true))) {
                return false;
            }
            toAdd.add(DistinctPairSet.createPair(pair.myFirst, secondIndex, true));
        }
        this.myData.addAll(toAdd.toArray());
        return true;
    }

    boolean addUnordered(int firstIndex, int secondIndex) {
        if (!this.myData.contains(DistinctPairSet.createPair(firstIndex, secondIndex, true)) && !this.myData.contains(DistinctPairSet.createPair(secondIndex, firstIndex, true))) {
            this.myData.add(DistinctPairSet.createPair(firstIndex, secondIndex, false));
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof DistinctPair)) {
            return false;
        }
        DistinctPair dp = (DistinctPair)o;
        EqClass first = dp.getFirst();
        EqClass second = dp.getSecond();
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        int firstVal = first.get(0);
        int secondVal = second.get(0);
        int firstIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(firstVal));
        int secondIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(secondVal));
        if (firstIndex == -1 || secondIndex == -1) {
            return false;
        }
        long pair = DistinctPairSet.createPair(firstIndex, secondIndex, dp.isOrdered());
        return this.myData.contains(pair) && this.decode(pair).equals(dp);
    }

    @Override
    public Iterator<DistinctPair> iterator() {
        return new Iterator<DistinctPair>(){
            final TLongIterator iterator;
            {
                this.iterator = DistinctPairSet.this.myData.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DistinctPair next() {
                return DistinctPairSet.this.decode(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.myData.size();
    }

    public boolean unite(int c1Index, int c2Index) {
        long[] distincts;
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myData.toArray()) {
            int pc1 = DistinctPairSet.low(distinct);
            int pc2 = DistinctPairSet.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        for (int i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myData.remove(c);
            if (c >= 0L) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.low(c) == c2Index ? DistinctPairSet.high(c) : DistinctPairSet.low(c), false));
                continue;
            }
            if (DistinctPairSet.low(c) == c2Index) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.high(c), true));
                continue;
            }
            this.myData.add(DistinctPairSet.createPair(DistinctPairSet.low(c), c1Index, true));
        }
        return true;
    }

    public boolean areDistinctUnordered(int c1Index, int c2Index) {
        return this.myData.contains(DistinctPairSet.createPair(c1Index, c2Index, false));
    }

    private DistinctPair decode(long encoded) {
        boolean ordered = encoded < 0L;
        encoded = Math.abs(encoded);
        return new DistinctPair(DistinctPairSet.low(encoded), DistinctPairSet.high(encoded), ordered, this.myState.getEqClasses());
    }

    private static long createPair(int low, int high, boolean ordered) {
        if (ordered) {
            return -(((long)high << 32) + (long)low);
        }
        return low < high ? ((long)low << 32) + (long)high : ((long)high << 32) + (long)low;
    }

    private static int low(long l) {
        return (int)Math.abs(l);
    }

    private static int high(long l) {
        return (int)((Math.abs(l) & 0xFFFFFFFF00000000L) >> 32);
    }

    static final class DistinctPair {
        private final int myFirst;
        private final int mySecond;
        private final boolean myOrdered;
        private final List<EqClass> myList;

        private DistinctPair(int first, int second, boolean ordered, List<EqClass> list) {
            this.myFirst = first;
            this.mySecond = second;
            this.myOrdered = ordered;
            this.myList = list;
        }

        @NotNull
        public EqClass getFirst() {
            EqClass eqClass = this.myList.get(this.myFirst);
            if (eqClass == null) {
                DistinctPair.$$$reportNull$$$0(0);
            }
            return eqClass;
        }

        @NotNull
        public EqClass getSecond() {
            EqClass eqClass = this.myList.get(this.mySecond);
            if (eqClass == null) {
                DistinctPair.$$$reportNull$$$0(1);
            }
            return eqClass;
        }

        public boolean isOrdered() {
            return this.myOrdered;
        }

        @Nullable
        public EqClass getOtherClass(int eqClassIndex) {
            if (this.myFirst == eqClassIndex) {
                return this.getSecond();
            }
            if (this.mySecond == eqClassIndex) {
                return this.getFirst();
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DistinctPair)) {
                return false;
            }
            DistinctPair that = (DistinctPair)obj;
            if (that.myOrdered != this.myOrdered) {
                return false;
            }
            return that.getFirst().equals(this.getFirst()) && that.getSecond().equals(this.getSecond()) || !this.myOrdered && that.getSecond().equals(this.getFirst()) && that.getFirst().equals(this.getSecond());
        }

        public int hashCode() {
            return this.getFirst().hashCode() * (this.myOrdered ? 31 : 1) + this.getSecond().hashCode();
        }

        public String toString() {
            return "{" + this.getFirst() + (this.myOrdered ? "<" : "!=") + this.getSecond() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/DistinctPairSet$DistinctPair";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirst";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecond";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

