/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class LoopAnalyzer {
    LoopAnalyzer() {
    }

    static int[] calcInLoop(ControlFlow controlFlow) {
        final int[] loop = new int[controlFlow.getInstructionCount()];
        MyGraph graph = new MyGraph(controlFlow);
        final DFSTBuilder builder = new DFSTBuilder((Graph)graph);
        TIntArrayList sccs = builder.getSCCs();
        sccs.forEach(new TIntProcedure(){
            private int myTNumber;
            private int component;

            public boolean execute(int size) {
                int value2 = size > 1 ? (this.component = this.component + 1) : 0;
                for (int i = 0; i < size; ++i) {
                    Instruction instruction = (Instruction)builder.getNodeByTNumber(this.myTNumber + i);
                    loop[instruction.getIndex()] = value2;
                }
                this.myTNumber += size;
                return true;
            }
        });
        return loop;
    }

    @NotNull
    static int[] getSuccessorIndices(int i, Instruction[] myInstructions) {
        int[] nArray;
        int offset;
        Instruction instruction = myInstructions[i];
        if (instruction instanceof GotoInstruction) {
            int[] nArray2 = new int[]{((GotoInstruction)instruction).getOffset()};
            if (nArray2 == null) {
                LoopAnalyzer.$$$reportNull$$$0(0);
            }
            return nArray2;
        }
        if (instruction instanceof ControlTransferInstruction) {
            int[] nArray3 = ArrayUtil.toIntArray(((ControlTransferInstruction)instruction).getPossibleTargetIndices());
            if (nArray3 == null) {
                LoopAnalyzer.$$$reportNull$$$0(1);
            }
            return nArray3;
        }
        if (instruction instanceof ConditionalGotoInstruction && (offset = ((ConditionalGotoInstruction)instruction).getOffset()) != i + 1) {
            int[] nArray4 = new int[]{i + 1, offset};
            if (nArray4 == null) {
                LoopAnalyzer.$$$reportNull$$$0(2);
            }
            return nArray4;
        }
        if (i == myInstructions.length - 1) {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
        } else {
            int[] nArray5 = new int[1];
            nArray = nArray5;
            nArray5[0] = i + 1;
        }
        if (nArray == null) {
            LoopAnalyzer.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer", "getSuccessorIndices"));
    }

    private static class MyGraph
    implements Graph<Instruction> {
        @NotNull
        private final ControlFlow myFlow;
        private final Instruction[] myInstructions;
        private final TIntObjectHashMap<int[]> myIns;

        private MyGraph(@NotNull ControlFlow flow) {
            if (flow == null) {
                MyGraph.$$$reportNull$$$0(0);
            }
            this.myIns = new TIntObjectHashMap();
            this.myFlow = flow;
            for (Instruction instruction : this.myInstructions = flow.getInstructions()) {
                int[] to;
                int fromIndex = instruction.getIndex();
                for (int toIndex : to = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions)) {
                    int[] froms = (int[])this.myIns.get(toIndex);
                    if (froms == null) {
                        froms = new int[]{fromIndex};
                        this.myIns.put(toIndex, (Object)froms);
                        continue;
                    }
                    froms = ArrayUtil.append((int[])froms, (int)fromIndex);
                    this.myIns.put(toIndex, (Object)froms);
                }
            }
        }

        public Collection<Instruction> getNodes() {
            return Arrays.asList(this.myFlow.getInstructions());
        }

        public Iterator<Instruction> getIn(Instruction n) {
            int[] ins = (int[])this.myIns.get(n.getIndex());
            return this.indicesToInstructions(ins);
        }

        public Iterator<Instruction> getOut(Instruction instruction) {
            int fromIndex = instruction.getIndex();
            int[] next = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions);
            return this.indicesToInstructions(next);
        }

        @NotNull
        private Iterator<Instruction> indicesToInstructions(int[] next) {
            if (next == null) {
                EmptyIterator emptyIterator = EmptyIterator.getInstance();
                if (emptyIterator == null) {
                    MyGraph.$$$reportNull$$$0(1);
                }
                return emptyIterator;
            }
            ArrayList<Instruction> out = new ArrayList<Instruction>(next.length);
            for (int i : next) {
                out.add(this.myInstructions[i]);
            }
            Iterator<Instruction> iterator = out.iterator();
            if (iterator == null) {
                MyGraph.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/LoopAnalyzer$MyGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/LoopAnalyzer$MyGraph";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "indicesToInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

