/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J%\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u001a\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001d2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001e\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001d2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcom/intellij/codeInspection/dataFlow/PurityInferenceResult;", "", "mutatedRefs", "", "Lcom/intellij/codeInspection/dataFlow/ExpressionRange;", "singleCall", "(Ljava/util/List;Lcom/intellij/codeInspection/dataFlow/ExpressionRange;)V", "getMutatedRefs$intellij_java_analysis_impl", "()Ljava/util/List;", "getSingleCall$intellij_java_analysis_impl", "()Lcom/intellij/codeInspection/dataFlow/ExpressionRange;", "callsOnlyPureMethods", "", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "component1", "component1$intellij_java_analysis_impl", "component2", "component2$intellij_java_analysis_impl", "copy", "equals", "other", "hashCode", "", "isLocalVarReference", "expression", "Lcom/intellij/psi/PsiExpression;", "scope", "Lcom/intellij/psi/PsiMethod;", "isLocallyCreatedArray", "target", "Lcom/intellij/psi/PsiLocalVariable;", "isPure", "method", "mutatesNonLocals", "toString", "", "intellij.java.analysis.impl"})
public final class PurityInferenceResult {
    @NotNull
    private final List<ExpressionRange> mutatedRefs;
    @Nullable
    private final ExpressionRange singleCall;

    public final boolean isPure(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body2) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        return !this.mutatesNonLocals(method, body2) && this.callsOnlyPureMethods(body2);
    }

    private final boolean mutatesNonLocals(PsiMethod method, Function0<? extends PsiCodeBlock> body2) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.mutatedRefs;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ExpressionRange range = (ExpressionRange)element$iv;
                    if (!(!this.isLocalVarReference(range.restoreExpression((PsiCodeBlock)body2.invoke()), method))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean callsOnlyPureMethods(Function0<? extends PsiCodeBlock> body2) {
        if (this.singleCall == null) {
            return true;
        }
        PsiExpression psiExpression = this.singleCall.restoreExpression((PsiCodeBlock)body2.invoke());
        if (psiExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiCall");
        }
        PsiMethod called = ((PsiCall)psiExpression).resolveMethod();
        return called != null && ControlFlowAnalyzer.isPure(called);
    }

    private final boolean isLocalVarReference(PsiExpression expression2, PsiMethod scope) {
        boolean bl;
        PsiExpression psiExpression = expression2;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement psiElement = ((PsiReferenceExpression)expression2).resolve();
            PsiElement it = psiElement;
            bl = it instanceof PsiLocalVariable || it instanceof PsiParameter;
        } else if (psiExpression instanceof PsiArrayAccessExpression) {
            PsiExpression psiExpression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            if (!(psiExpression2 instanceof PsiReferenceExpression)) {
                psiExpression2 = null;
            }
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiExpression2;
            Object object = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
            PsiElement target = object;
            bl = target instanceof PsiLocalVariable && this.isLocallyCreatedArray(scope, (PsiLocalVariable)target);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isLocallyCreatedArray(PsiMethod scope, PsiLocalVariable target) {
        PsiExpression initializer = target.getInitializer();
        if (initializer != null && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)((PsiElement)target), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)scope))).findAll()) {
            PsiAssignmentExpression assign;
            if (!(ref instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)ref)) || (assign = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ref), PsiAssignmentExpression.class)) != null && assign.getRExpression() instanceof PsiNewExpression) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<ExpressionRange> getMutatedRefs$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange getSingleCall$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    public PurityInferenceResult(@NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkParameterIsNotNull(mutatedRefs, (String)"mutatedRefs");
        this.mutatedRefs = mutatedRefs;
        this.singleCall = singleCall;
    }

    @NotNull
    public final List<ExpressionRange> component1$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange component2$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    @NotNull
    public final PurityInferenceResult copy(@NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkParameterIsNotNull(mutatedRefs, (String)"mutatedRefs");
        return new PurityInferenceResult(mutatedRefs, singleCall);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PurityInferenceResult copy$default(PurityInferenceResult purityInferenceResult, List list, ExpressionRange expressionRange, int n, Object object) {
        if ((n & 1) != 0) {
            list = purityInferenceResult.mutatedRefs;
        }
        if ((n & 2) != 0) {
            expressionRange = purityInferenceResult.singleCall;
        }
        return purityInferenceResult.copy(list, expressionRange);
    }

    public String toString() {
        return "PurityInferenceResult(mutatedRefs=" + this.mutatedRefs + ", singleCall=" + this.singleCall + ")";
    }

    public int hashCode() {
        List<ExpressionRange> list = this.mutatedRefs;
        ExpressionRange expressionRange = this.singleCall;
        return (list != null ? ((Object)list).hashCode() : 0) * 31 + (expressionRange != null ? ((Object)expressionRange).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PurityInferenceResult)) break block3;
                PurityInferenceResult purityInferenceResult = (PurityInferenceResult)object;
                if (!Intrinsics.areEqual(this.mutatedRefs, purityInferenceResult.mutatedRefs) || !Intrinsics.areEqual((Object)this.singleCall, (Object)purityInferenceResult.singleCall)) break block3;
            }
            return true;
        }
        return false;
    }
}

