/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9RedundantRequiresStatementInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java9RedundantRequiresStatementInspection.class);
    private static final Key<Set<String>> IMPORTED_JAVA_PACKAGES = Key.create((String)"imported_java_packages");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.name", (Object[])new Object[0]);
        if (string == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(4);
        }
        if (refEntity instanceof RefJavaModule) {
            List requiredModules;
            Set moduleImportedPackages;
            RefJavaModule refJavaModule = (RefJavaModule)refEntity;
            RefModule refModule = refJavaModule.getModule();
            PsiJavaModule psiJavaModule = refJavaModule.getElement();
            if (refModule != null && psiJavaModule != null && (moduleImportedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES)) != null && !(requiredModules = refJavaModule.getRequiredModules()).isEmpty()) {
                ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                for (RefJavaModule.RequiredModule requiredModule : requiredModules) {
                    PsiRequiresStatement requiresStatement;
                    String requiredModuleName = requiredModule.moduleName;
                    if (!"java.base".equals(requiredModuleName) && !Java9RedundantRequiresStatementInspection.isDependencyUnused(requiredModule.packagesExportedByModule, moduleImportedPackages, refJavaModule.getName()) || (requiresStatement = (PsiRequiresStatement)ContainerUtil.find((Iterable)psiJavaModule.getRequires(), statement -> requiredModuleName.equals(statement.getModuleName()))) == null) continue;
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)requiresStatement, InspectionsBundle.message((String)"inspection.redundant.requires.statement.description", (Object[])new Object[]{requiredModuleName}), (LocalQuickFix)new DeleteRedundantRequiresStatementFix(requiredModuleName, moduleImportedPackages), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    descriptors.add(descriptor);
                }
                if (!ContainerUtil.isEmpty(descriptors)) {
                    return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                }
            }
        }
        return null;
    }

    private static boolean isDependencyUnused(@NotNull Map<String, List<String>> dependencyExportedPackages, @NotNull Set<String> importedPackageNames, @NotNull String contextModuleName) {
        if (dependencyExportedPackages == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(5);
        }
        if (importedPackageNames == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(6);
        }
        if (contextModuleName == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(7);
        }
        for (Map.Entry<String, List<String>> entry : dependencyExportedPackages.entrySet()) {
            String exportedPackageName = entry.getKey();
            List<String> exportedToModules = entry.getValue();
            if (!exportedToModules.isEmpty() && !exportedToModules.contains(contextModuleName) || !importedPackageNames.contains(exportedPackageName)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(8);
        }
        return new RedundantRequiresStatementAnnotator();
    }

    private static PsiJavaModule resolveRequiredModule(PsiRequiresStatement requiresStatement) {
        return PsiJavaModuleReference.resolve((PsiElement)requiresStatement, requiresStatement.getModuleName(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyExportedPackages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedPackageNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModuleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyUnused";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RedundantRequiresStatementAnnotator
    extends RefGraphAnnotator {
        private static final Set<String> DONT_COLLECT_PACKAGES = Collections.emptySet();

        private RedundantRequiresStatementAnnotator() {
        }

        public void onReferencesBuild(RefElement refElement) {
            RefModule refModule;
            if (refElement instanceof RefFile) {
                RefFile refFile = (RefFile)refElement;
                PsiFile file = refFile.getElement();
                if (file instanceof PsiJavaFile) {
                    RedundantRequiresStatementAnnotator.onJavaFileReferencesBuilt(refFile, (PsiJavaFile)file);
                }
            } else if (refElement instanceof RefJavaModule && (refModule = refElement.getModule()) != null) {
                RedundantRequiresStatementAnnotator.setImportedPackages(refModule, refElement.getElement() != null);
            }
        }

        private static void onJavaFileReferencesBuilt(@NotNull RefFile refFile, @NotNull PsiJavaFile file) {
            Set<String> packageNames;
            RefModule refModule;
            PsiImportList importList;
            if (refFile == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(0);
            }
            if (file == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(1);
            }
            if (file.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (importList = file.getImportList()) != null && (refModule = refFile.getModule()) != null && (packageNames = RedundantRequiresStatementAnnotator.getImportedPackages(refModule, refFile)) != DONT_COLLECT_PACKAGES) {
                PsiImportStatementBase[] statements;
                for (PsiImportStatementBase statement : statements = importList.getAllImportStatements()) {
                    String packageName = RedundantRequiresStatementAnnotator.getPackageName(statement);
                    if (StringUtil.isEmpty((String)packageName)) continue;
                    packageNames.add(packageName);
                }
            }
        }

        @Nullable
        private static String getPackageName(@NotNull PsiImportStatementBase statement) {
            PsiJavaFile parentFile;
            PsiElement resolved;
            if (statement == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(2);
            }
            if ((resolved = statement.resolve()) instanceof PsiPackage) {
                return ((PsiPackage)resolved).getQualifiedName();
            }
            if (resolved instanceof PsiMember && (parentFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiJavaFile.class)) != null) {
                return parentFile.getPackageName();
            }
            return null;
        }

        @NotNull
        private static Set<String> getImportedPackages(@NotNull RefModule refModule, @NotNull RefFile refFile) {
            Set importedPackages;
            if (refModule == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(3);
            }
            if (refFile == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(4);
            }
            if ((importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES)) == null) {
                PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)refFile.getElement());
                importedPackages = javaModule != null ? new THashSet() : DONT_COLLECT_PACKAGES;
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)importedPackages);
            }
            Set set = importedPackages;
            if (set == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(5);
            }
            return set;
        }

        private static void setImportedPackages(RefModule refModule, boolean collectPackages) {
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)(collectPackages ? new THashSet() : DONT_COLLECT_PACKAGES));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refModule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportedPackages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onJavaFileReferencesBuilt";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getImportedPackages";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeleteRedundantRequiresStatementFix
    implements LocalQuickFix {
        private final String myRequiredModuleName;
        private final Set<String> myImportedPackages;

        public DeleteRedundantRequiresStatementFix(String requiredModuleName, Set<String> importedPackages) {
            this.myRequiredModuleName = requiredModuleName;
            this.myImportedPackages = importedPackages;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.family", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.name", (Object[])new Object[]{this.myRequiredModuleName});
            if (string == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(3);
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            LOG.assertTrue(element instanceof PsiRequiresStatement, (Object)"Should be 'requires' statement");
            PsiRequiresStatement statementToDelete = (PsiRequiresStatement)element;
            this.addTransitiveDependencies(statementToDelete);
            statementToDelete.delete();
        }

        private Set<String> getReexportedDependencies(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule dependencyModule) {
            if (currentModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(4);
            }
            if (dependencyModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(5);
            }
            Set directDependencies = StreamEx.of(currentModule.getRequires().iterator()).map(PsiRequiresStatement::getModuleName).nonNull().toSet();
            List transitiveModules = ((StreamEx)((StreamEx)StreamEx.of(dependencyModule.getRequires().iterator()).filter(statement -> statement.hasModifierProperty("transitive"))).filter(requiresStatement -> !directDependencies.contains(requiresStatement.getModuleName()))).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).nonNull().toList();
            return ((StreamEx)StreamEx.of((Collection)transitiveModules).filter(transitiveModule -> {
                if (currentModule == null) {
                    DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(15);
                }
                return this.isReexported(currentModule, (PsiJavaModule)transitiveModule);
            })).map(transitiveModule -> transitiveModule.getName()).toSet();
        }

        private boolean isReexported(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule transitiveModule) {
            if (currentModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(6);
            }
            if (transitiveModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(7);
            }
            return ((StreamEx)StreamEx.of(transitiveModule.getExports().iterator()).map(PsiPackageAccessibilityStatement::getPackageName).nonNull().filter(this.myImportedPackages::contains)).anyMatch(packageName -> {
                if (transitiveModule == null) {
                    DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(13);
                }
                if (currentModule == null) {
                    DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(14);
                }
                return JavaModuleGraphUtil.exports(transitiveModule, packageName, currentModule);
            });
        }

        private void addTransitiveDependencies(@NotNull PsiRequiresStatement statementToDelete) {
            PsiElement parent;
            if (statementToDelete == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(8);
            }
            if ((parent = statementToDelete.getParent()) instanceof PsiJavaModule) {
                PsiJavaModule currentModule = (PsiJavaModule)parent;
                Optional.of(statementToDelete).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).map(dependencyModule -> this.getReexportedDependencies(currentModule, (PsiJavaModule)dependencyModule)).ifPresent(reexportedDependencies -> {
                    if (statementToDelete == null) {
                        DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(12);
                    }
                    DeleteRedundantRequiresStatementFix.addReexportedDependencies(reexportedDependencies, currentModule, (PsiElement)statementToDelete);
                });
            }
        }

        private static void addReexportedDependencies(@NotNull Set<String> reexportedDependencies, @NotNull PsiJavaModule currentModule, @NotNull PsiElement addingPlace) {
            if (reexportedDependencies == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(9);
            }
            if (currentModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(10);
            }
            if (addingPlace == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(11);
            }
            if (!reexportedDependencies.isEmpty()) {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)currentModule.getProject()).getParserFacade();
                for (String dependencyName : reexportedDependencies) {
                    PsiStatement requiresStatement = parserFacade.createModuleStatementFromText("requires " + dependencyName);
                    currentModule.addAfter((PsiElement)requiresStatement, addingPlace);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 6: 
                case 10: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentModule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyModule";
                    break;
                }
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transitiveModule";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementToDelete";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reexportedDependencies";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addingPlace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getReexportedDependencies";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isReexported";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addTransitiveDependencies";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addReexportedDependencies";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addTransitiveDependencies$8";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isReexported$5";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getReexportedDependencies$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

