/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_COMPLETE = Key.create((String)"java.module.ref.text.resolve.complete");
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_INCOMPLETE = Key.create((String)"java.module.ref.text.resolve.incomplete");

    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element, new TextRange(0, element.getTextLength()), false);
    }

    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element;
        if (newName == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(4);
        }
        if ((element = (PsiJavaModuleReferenceElement)this.getElement()) instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message((String)"psi.error.attempt.to.edit.class.file", (Object[])new Object[]{element.getContainingFile()}));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.SERVICE.getInstance((Project)element.getProject()).createModuleReferenceFromText(newName);
        return element.replace((PsiElement)newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    @Nullable
    public static PsiJavaModule resolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        Collection<PsiJavaModule> modules;
        if (refOwner == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(5);
        }
        return (modules = PsiJavaModuleReference.multiResolve(refOwner, refText, incompleteCode)).size() == 1 ? modules.iterator().next() : null;
    }

    @NotNull
    public static Collection<PsiJavaModule> multiResolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (refOwner == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)refText)) {
            List<PsiJavaModule> list = Collections.emptyList();
            if (list == null) {
                PsiJavaModuleReference.$$$reportNull$$$0(7);
            }
            return list;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)refOwner.getProject());
        Key<CachedValue<Collection<PsiJavaModule>>> key2 = incompleteCode ? K_INCOMPLETE : K_COMPLETE;
        Collection collection = (Collection)manager.getCachedValue((UserDataHolder)refOwner, key2, () -> {
            if (refOwner == null) {
                PsiJavaModuleReference.$$$reportNull$$$0(9);
            }
            Collection modules = Resolver.findModules(refOwner.getContainingFile(), refText, incompleteCode);
            return CachedValueProvider.Result.create((Object)modules, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
        if (collection == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$multiResolve$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            PsiJavaModule module;
            if (reference == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference.getElement();
            PsiFile file = refElement.getContainingFile();
            String moduleName = reference.getCanonicalText();
            if (file instanceof PsiJavaFile && (module = ((PsiJavaFile)file).getModuleDeclaration()) != null && module.getName().equals(moduleName)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)module)};
                if (resolveResultArray == null) {
                    Resolver.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Collection<PsiJavaModule> modules = Resolver.findModules(file, moduleName, global);
            if (!modules.isEmpty()) {
                ResolveResult[] result = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module2 : modules) {
                    result[i++] = new PsiElementResolveResult((PsiElement)module2);
                }
                if (result == null) {
                    Resolver.$$$reportNull$$$0(2);
                }
                return result;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static Collection<PsiJavaModule> findModules(PsiFile file, String moduleName, boolean global) {
            Project project = file.getProject();
            GlobalSearchScope scope = global ? GlobalSearchScope.allScope((Project)project) : file.getResolveScope();
            return JavaFileManager.getInstance(project).findModules(moduleName, scope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

