/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeInfoImpl
extends UserDataHolderBase
implements JavaChangeInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.JavaChangeInfoImpl");
    @PsiModifier.ModifierConstant
    final String newVisibility;
    private PsiMethod method;
    String oldName;
    final String oldType;
    String[] oldParameterNames;
    String[] oldParameterTypes;
    final String newName;
    final CanonicalTypes.Type newReturnType;
    final ParameterInfoImpl[] newParms;
    ThrownExceptionInfo[] newExceptions;
    final boolean[] toRemoveParm;
    boolean isVisibilityChanged;
    boolean isNameChanged;
    boolean isReturnTypeChanged;
    boolean isParameterSetOrOrderChanged;
    boolean isExceptionSetChanged;
    boolean isExceptionSetOrOrderChanged;
    boolean isParameterNamesChanged;
    boolean isParameterTypesChanged;
    boolean isPropagationEnabled;
    final boolean wasVararg;
    final boolean retainsVarargs;
    final boolean obtainsVarags;
    final boolean arrayToVarargs;
    PsiIdentifier newNameIdentifier;
    final PsiExpression[] defaultValues;
    final boolean isGenerateDelegate;
    final Set<PsiMethod> propagateParametersMethods;
    final Set<PsiMethod> propagateExceptionsMethods;
    private boolean myCheckUnusedParameter;

    public JavaChangeInfoImpl(@PsiModifier.ModifierConstant String newVisibility, PsiMethod method, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] newParms, ThrownExceptionInfo[] newExceptions, boolean generateDelegate, Set<PsiMethod> propagateParametersMethods, Set<PsiMethod> propagateExceptionsMethods) {
        if (newParms == null) {
            JavaChangeInfoImpl.$$$reportNull$$$0(0);
        }
        this(newVisibility, method, newName, newType, newParms, newExceptions, generateDelegate, propagateParametersMethods, propagateExceptionsMethods, method.getName());
    }

    public JavaChangeInfoImpl(@PsiModifier.ModifierConstant String newVisibility, PsiMethod method, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] newParms, ThrownExceptionInfo[] newExceptions, boolean generateDelegate, Set<PsiMethod> propagateParametersMethods, Set<PsiMethod> propagateExceptionsMethods, String oldName) {
        if (newParms == null) {
            JavaChangeInfoImpl.$$$reportNull$$$0(1);
        }
        this.isPropagationEnabled = true;
        this.myCheckUnusedParameter = false;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        this.newVisibility = newVisibility;
        this.method = method;
        this.newName = newName;
        this.newReturnType = newType;
        this.newParms = newParms;
        this.wasVararg = method.isVarArgs();
        this.isGenerateDelegate = generateDelegate;
        this.propagateExceptionsMethods = propagateExceptionsMethods;
        this.propagateParametersMethods = propagateParametersMethods;
        this.oldName = oldName;
        if (!method.isConstructor()) {
            PsiType type2 = method.getReturnType();
            assert (type2 != null) : method;
            this.oldType = factory.createTypeElement(type2).getText();
        } else {
            this.oldType = null;
        }
        this.fillOldParams(method);
        this.isVisibilityChanged = !method.hasModifierProperty(newVisibility);
        boolean bl = this.isNameChanged = !newName.equals(this.oldName);
        if (this.oldParameterNames.length != newParms.length) {
            this.isParameterSetOrOrderChanged = true;
        } else {
            for (int i = 0; i < newParms.length; ++i) {
                ParameterInfoImpl parmInfo = newParms[i];
                if (i != parmInfo.oldParameterIndex) {
                    this.isParameterSetOrOrderChanged = true;
                    break;
                }
                if (!parmInfo.getName().equals(this.oldParameterNames[i])) {
                    this.isParameterNamesChanged = true;
                }
                try {
                    if (parmInfo.getTypeText().equals(this.oldParameterTypes[i])) continue;
                    this.isParameterTypesChanged = true;
                    continue;
                }
                catch (IncorrectOperationException e) {
                    this.isParameterTypesChanged = true;
                }
            }
        }
        this.setupPropagationEnabled(method.getParameterList().getParameters(), newParms);
        this.setupExceptions(newExceptions, method);
        this.toRemoveParm = new boolean[this.oldParameterNames.length];
        Arrays.fill(this.toRemoveParm, true);
        for (ParameterInfoImpl info : newParms) {
            if (info.oldParameterIndex < 0) continue;
            this.toRemoveParm[info.oldParameterIndex] = false;
        }
        this.defaultValues = new PsiExpression[newParms.length];
        for (int i = 0; i < newParms.length; ++i) {
            ParameterInfoImpl info = newParms[i];
            if (info.oldParameterIndex >= 0 || info.isVarargType() || StringUtil.isEmpty((String)info.defaultValue)) continue;
            try {
                this.defaultValues[i] = factory.createExpressionFromText(info.defaultValue, (PsiElement)method);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
        if (this.newParms.length == 0) {
            this.retainsVarargs = false;
            this.obtainsVarags = false;
            this.arrayToVarargs = false;
        } else {
            ParameterInfoImpl lastNewParm = this.newParms[this.newParms.length - 1];
            this.obtainsVarags = lastNewParm.isVarargType();
            this.retainsVarargs = lastNewParm.oldParameterIndex >= 0 && this.obtainsVarags;
            this.arrayToVarargs = this.retainsVarargs ? this.oldParameterTypes[lastNewParm.oldParameterIndex].endsWith("[]") : false;
        }
        if (this.isNameChanged) {
            this.newNameIdentifier = factory.createIdentifier(newName);
        }
    }

    @Override
    public boolean checkUnusedParameter() {
        return this.myCheckUnusedParameter;
    }

    public void setCheckUnusedParameter() {
        this.myCheckUnusedParameter = true;
    }

    protected void fillOldParams(PsiMethod method) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        this.oldParameterNames = new String[parameters2.length];
        this.oldParameterTypes = new String[parameters2.length];
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            this.oldParameterNames[i] = parameter2.getName();
            this.oldParameterTypes[i] = factory.createTypeElement(parameter2.getType()).getText();
        }
        if (!method.isConstructor()) {
            try {
                this.isReturnTypeChanged = !ChangeSignatureUtil.deepTypeEqual(this.newReturnType.getType((PsiElement)this.method), this.method.getReturnType());
            }
            catch (IncorrectOperationException e) {
                this.isReturnTypeChanged = true;
            }
        }
    }

    @Override
    @NotNull
    public JavaParameterInfo[] getNewParameters() {
        if (this.newParms == null) {
            JavaChangeInfoImpl.$$$reportNull$$$0(2);
        }
        return this.newParms;
    }

    @Override
    @PsiModifier.ModifierConstant
    public String getNewVisibility() {
        return this.newVisibility;
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.isParameterSetOrOrderChanged;
    }

    private void setupExceptions(ThrownExceptionInfo[] newExceptions, PsiMethod method) {
        if (newExceptions == null) {
            newExceptions = JavaThrownExceptionInfo.extractExceptions(method);
        }
        this.newExceptions = newExceptions;
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        boolean bl = this.isExceptionSetChanged = newExceptions.length != types.length;
        if (!this.isExceptionSetChanged) {
            for (int i = 0; i < newExceptions.length; ++i) {
                try {
                    if (newExceptions[i].getOldIndex() < 0 || !ChangeSignatureUtil.deepTypeEqual((PsiType)types[i], newExceptions[i].createType((PsiElement)method, method.getManager()))) {
                        this.isExceptionSetChanged = true;
                        break;
                    }
                }
                catch (IncorrectOperationException e) {
                    this.isExceptionSetChanged = true;
                }
                if (newExceptions[i].getOldIndex() == i) continue;
                this.isExceptionSetOrOrderChanged = true;
            }
        }
        this.isExceptionSetOrOrderChanged |= this.isExceptionSetChanged;
    }

    protected void setupPropagationEnabled(PsiParameter[] parameters2, ParameterInfoImpl[] newParms) {
        if (parameters2.length >= newParms.length) {
            this.isPropagationEnabled = false;
        } else {
            this.isPropagationEnabled = !this.propagateParametersMethods.isEmpty();
            for (int i = 0; i < parameters2.length; ++i) {
                ParameterInfoImpl newParm = newParms[i];
                if (newParm.oldParameterIndex == i) continue;
                this.isPropagationEnabled = false;
                break;
            }
        }
    }

    @Override
    public PsiMethod getMethod() {
        return this.method;
    }

    @Override
    public CanonicalTypes.Type getNewReturnType() {
        return this.newReturnType;
    }

    @Override
    public void updateMethod(PsiMethod method) {
        this.method = method;
    }

    @Override
    public Collection<PsiMethod> getMethodsToPropagateParameters() {
        return this.propagateParametersMethods;
    }

    public ParameterInfoImpl[] getCreatedParmsInfoWithoutVarargs() {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        for (ParameterInfoImpl newParm : this.newParms) {
            if (newParm.oldParameterIndex >= 0 || newParm.isVarargType()) continue;
            result.add(newParm);
        }
        return result.toArray(new ParameterInfoImpl[0]);
    }

    @Override
    @Nullable
    public PsiExpression getValue(int i, PsiCallExpression expr) throws IncorrectOperationException {
        if (this.defaultValues[i] != null) {
            return this.defaultValues[i];
        }
        PsiElement valueAtCallSite = this.newParms[i].getActualValue((PsiElement)expr, PsiSubstitutor.EMPTY);
        return valueAtCallSite instanceof PsiExpression ? (PsiExpression)valueAtCallSite : null;
    }

    @Override
    public boolean isVisibilityChanged() {
        return this.isVisibilityChanged;
    }

    public boolean isNameChanged() {
        return this.isNameChanged;
    }

    public boolean isReturnTypeChanged() {
        return this.isReturnTypeChanged;
    }

    public String getNewName() {
        return this.newName;
    }

    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @Override
    public boolean isExceptionSetChanged() {
        return this.isExceptionSetChanged;
    }

    @Override
    public boolean isExceptionSetOrOrderChanged() {
        return this.isExceptionSetOrOrderChanged;
    }

    public boolean isParameterNamesChanged() {
        return this.isParameterNamesChanged;
    }

    public boolean isParameterTypesChanged() {
        return this.isParameterTypesChanged;
    }

    public boolean isGenerateDelegate() {
        return this.isGenerateDelegate;
    }

    @Override
    @NotNull
    public String[] getOldParameterNames() {
        if (this.oldParameterNames == null) {
            JavaChangeInfoImpl.$$$reportNull$$$0(3);
        }
        return this.oldParameterNames;
    }

    @Override
    @NotNull
    public String[] getOldParameterTypes() {
        if (this.oldParameterTypes == null) {
            JavaChangeInfoImpl.$$$reportNull$$$0(4);
        }
        return this.oldParameterTypes;
    }

    @Override
    public ThrownExceptionInfo[] getNewExceptions() {
        return this.newExceptions;
    }

    @Override
    public boolean isRetainsVarargs() {
        return this.retainsVarargs;
    }

    @Override
    public boolean isObtainsVarags() {
        return this.obtainsVarags;
    }

    @Override
    public boolean isArrayToVarargs() {
        return this.arrayToVarargs;
    }

    @Override
    public PsiIdentifier getNewNameIdentifier() {
        return this.newNameIdentifier;
    }

    @Override
    public String getOldName() {
        return this.oldName;
    }

    @Override
    public boolean wasVararg() {
        return this.wasVararg;
    }

    @Override
    public boolean[] toRemoveParm() {
        return this.toRemoveParm;
    }

    protected boolean checkMethodEquality() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaChangeInfoImpl)) {
            return false;
        }
        JavaChangeInfoImpl that = (JavaChangeInfoImpl)o;
        if (this.arrayToVarargs != that.arrayToVarargs) {
            return false;
        }
        if (this.isExceptionSetChanged != that.isExceptionSetChanged) {
            return false;
        }
        if (this.isExceptionSetOrOrderChanged != that.isExceptionSetOrOrderChanged) {
            return false;
        }
        if (this.isGenerateDelegate != that.isGenerateDelegate) {
            return false;
        }
        if (this.isNameChanged != that.isNameChanged) {
            return false;
        }
        if (this.isParameterNamesChanged != that.isParameterNamesChanged) {
            return false;
        }
        if (this.isParameterSetOrOrderChanged != that.isParameterSetOrOrderChanged) {
            return false;
        }
        if (this.isParameterTypesChanged != that.isParameterTypesChanged) {
            return false;
        }
        if (this.isPropagationEnabled != that.isPropagationEnabled) {
            return false;
        }
        if (this.isReturnTypeChanged != that.isReturnTypeChanged) {
            return false;
        }
        if (this.isVisibilityChanged != that.isVisibilityChanged) {
            return false;
        }
        if (this.obtainsVarags != that.obtainsVarags) {
            return false;
        }
        if (this.retainsVarargs != that.retainsVarargs) {
            return false;
        }
        if (this.wasVararg != that.wasVararg) {
            return false;
        }
        if (!Arrays.equals(this.defaultValues, that.defaultValues)) {
            return false;
        }
        if (this.checkMethodEquality() && !this.method.equals(that.method)) {
            return false;
        }
        if (!Arrays.equals(this.newExceptions, that.newExceptions)) {
            return false;
        }
        if (!this.newName.equals(that.newName)) {
            return false;
        }
        if (this.newNameIdentifier != null ? !this.newNameIdentifier.equals(that.newNameIdentifier) : that.newNameIdentifier != null) {
            return false;
        }
        if (!Arrays.equals(this.newParms, that.newParms)) {
            return false;
        }
        if (this.newReturnType != null ? that.newReturnType == null || !Comparing.strEqual((String)this.newReturnType.getTypeText(), (String)that.newReturnType.getTypeText()) : that.newReturnType != null) {
            return false;
        }
        if (this.newVisibility != null ? !this.newVisibility.equals(that.newVisibility) : that.newVisibility != null) {
            return false;
        }
        if (!this.oldName.equals(that.oldName)) {
            return false;
        }
        if (!Arrays.equals(this.oldParameterNames, that.oldParameterNames)) {
            return false;
        }
        if (!Arrays.equals(this.oldParameterTypes, that.oldParameterTypes)) {
            return false;
        }
        if (this.oldType != null ? !this.oldType.equals(that.oldType) : that.oldType != null) {
            return false;
        }
        if (!this.propagateExceptionsMethods.equals(that.propagateExceptionsMethods)) {
            return false;
        }
        if (!this.propagateParametersMethods.equals(that.propagateParametersMethods)) {
            return false;
        }
        return Arrays.equals(this.toRemoveParm, that.toRemoveParm);
    }

    public int hashCode() {
        int result;
        int n = result = this.newVisibility != null ? this.newVisibility.hashCode() : 0;
        if (this.checkMethodEquality()) {
            result = 31 * result + this.method.hashCode();
        }
        result = 31 * result + this.oldName.hashCode();
        result = 31 * result + (this.oldType != null ? this.oldType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.oldParameterNames);
        result = 31 * result + Arrays.hashCode(this.oldParameterTypes);
        result = 31 * result + this.newName.hashCode();
        result = 31 * result + (this.newReturnType != null ? this.newReturnType.getTypeText().hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.newParms);
        result = 31 * result + Arrays.hashCode(this.newExceptions);
        result = 31 * result + Arrays.hashCode(this.toRemoveParm);
        result = 31 * result + (this.isVisibilityChanged ? 1 : 0);
        result = 31 * result + (this.isNameChanged ? 1 : 0);
        result = 31 * result + (this.isReturnTypeChanged ? 1 : 0);
        result = 31 * result + (this.isParameterSetOrOrderChanged ? 1 : 0);
        result = 31 * result + (this.isExceptionSetChanged ? 1 : 0);
        result = 31 * result + (this.isExceptionSetOrOrderChanged ? 1 : 0);
        result = 31 * result + (this.isParameterNamesChanged ? 1 : 0);
        result = 31 * result + (this.isParameterTypesChanged ? 1 : 0);
        result = 31 * result + (this.isPropagationEnabled ? 1 : 0);
        result = 31 * result + (this.wasVararg ? 1 : 0);
        result = 31 * result + (this.retainsVarargs ? 1 : 0);
        result = 31 * result + (this.obtainsVarags ? 1 : 0);
        result = 31 * result + (this.arrayToVarargs ? 1 : 0);
        result = 31 * result + (this.newNameIdentifier != null ? this.newNameIdentifier.hashCode() : 0);
        result = 31 * result + (this.defaultValues != null ? Arrays.hashCode(this.defaultValues) : 0);
        result = 31 * result + (this.isGenerateDelegate ? 1 : 0);
        result = 31 * result + this.propagateParametersMethods.hashCode();
        result = 31 * result + this.propagateExceptionsMethods.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParms";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeInfoImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldParameterNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

