/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.PreviewPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;

public class ExtractMethodPreviewManager {
    private final Project myProject;
    private ContentManager myContentManager;

    public ExtractMethodPreviewManager(Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.EXTRACT_METHOD, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject);
            this.myContentManager = toolWindow.getContentManager();
            new ContentManagerWatcher(toolWindow, this.myContentManager);
        });
    }

    public void showPreview(ExtractMethodProcessor processor) {
        String title = processor.getMethodName() + "()";
        PreviewPanel panel = new PreviewPanel(processor);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)panel), title, true);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        panel.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.EXTRACT_METHOD).activate(panel::initLater);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
        content.release();
    }

    public static ExtractMethodPreviewManager getInstance(Project project) {
        return (ExtractMethodPreviewManager)ServiceManager.getService((Project)project, ExtractMethodPreviewManager.class);
    }
}

