/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.ExtractMethodPreviewManager;
import com.intellij.refactoring.extractMethod.preview.PreviewDiffPanel;
import com.intellij.refactoring.extractMethod.preview.PreviewExclusionHandler;
import com.intellij.refactoring.extractMethod.preview.PreviewTree;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

class PreviewPanel
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    private final Project myProject;
    private final PreviewTree myTree;
    private final ExclusionHandler<DefaultMutableTreeNode> myExclusionHandler;
    private Content myContent;
    private final PreviewDiffPanel myDiffPanel;

    public PreviewPanel(ExtractMethodProcessor processor) {
        this.myProject = processor.getProject();
        this.myTree = new PreviewTree(processor);
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent());
        treePane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 4);
        this.myDiffPanel = new PreviewDiffPanel(processor);
        this.myTree.addTreeListener(this.myDiffPanel);
        BorderLayoutPanel leftPanel = new BorderLayoutPanel();
        leftPanel.addToCenter((Component)treePane);
        leftPanel.addToBottom((Component)new ButtonsPanel(this.myProject));
        JBSplitter splitter = new JBSplitter(false);
        splitter.setProportion(0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)((Object)this.myDiffPanel));
        this.addToCenter((Component)splitter);
        this.myExclusionHandler = new PreviewExclusionHandler(this);
        Disposer.register((Disposable)processor.getProject(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myDiffPanel);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Object getData(String dataId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setContent(Content content) {
        this.myContent = content;
        content.setDisposer((Disposable)this);
    }

    public void initLater() {
        this.myDiffPanel.initLater(this.myTree.getAllDuplicates(), () -> this.myTree.onSelectionUpdate());
    }

    public void dispose() {
    }

    private void close() {
        if (this.myContent != null) {
            ExtractMethodPreviewManager.getInstance(this.myProject).closeContent(this.myContent);
        }
    }

    private void doRefactor() {
        this.myDiffPanel.doExtract(this.myTree.getEnabledDuplicates());
        this.close();
    }

    void onTreeUpdated() {
        this.myTree.getComponent().repaint();
    }

    private static /* synthetic */ Navigatable[] lambda$getData$1(int x$0) {
        return new Navigatable[x$0];
    }

    private class ButtonsPanel
    extends JPanel {
        private final JButton myRefactorButton;
        private final JButton myCancelButton;

        public ButtonsPanel(Project project) {
            super(new FlowLayout(0, JBUI.scale((int)8), 0));
            this.myRefactorButton = new JButton("Do Refactor");
            this.myRefactorButton.addActionListener(e -> PreviewPanel.this.doRefactor());
            this.add(this.myRefactorButton);
            this.myCancelButton = new JButton("Cancel");
            this.myCancelButton.addActionListener(e -> PreviewPanel.this.close());
            this.add(this.myCancelButton);
            project.getMessageBus().connect((Disposable)PreviewPanel.this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    ButtonsPanel.this.update(true);
                }

                public void exitDumbMode() {
                    ButtonsPanel.this.update(false);
                }
            });
        }

        void update(boolean isDumb) {
            this.myRefactorButton.setEnabled(!isDumb);
            this.myCancelButton.setEnabled(!isDumb);
        }
    }
}

