/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class InlineDelegatingCall
extends FixableUsageInfo {
    private final PsiMethodCallExpression expression;
    private final String myAccess;
    private final String delegatingName;
    private final int[] paramaterPermutation;

    public InlineDelegatingCall(PsiMethodCallExpression expression2, int[] paramaterPermutation, String access, String delegatingName) {
        super((PsiElement)expression2);
        this.expression = expression2;
        this.paramaterPermutation = paramaterPermutation;
        this.myAccess = access;
        this.delegatingName = delegatingName;
    }

    public void fixUsage() throws IncorrectOperationException {
        StringBuffer replacementText = new StringBuffer();
        PsiReferenceExpression methodExpression = this.expression.getMethodExpression();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier != null) {
            String qualifierText = qualifier.getText();
            replacementText.append(qualifierText + '.');
        }
        replacementText.append(this.myAccess).append(".");
        replacementText.append(this.delegatingName).append('(');
        PsiExpressionList argumentList = this.expression.getArgumentList();
        assert (argumentList != null);
        PsiExpression[] args = argumentList.getExpressions();
        boolean first = true;
        for (int i : this.paramaterPermutation) {
            if (!first) {
                replacementText.append(", ");
            }
            first = false;
            String argText = args[i].getText();
            replacementText.append(argText);
        }
        replacementText.append(')');
        String replacementTextString = replacementText.toString();
        MutationUtils.replaceExpression(replacementTextString, (PsiExpression)this.expression);
    }
}

