/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopeUtils {
    private ScopeUtils() {
    }

    @Nullable
    public static PsiElement findTighterDeclarationLocation(@NotNull PsiElement sibling, @NotNull PsiVariable variable) {
        if (sibling == null) {
            ScopeUtils.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            ScopeUtils.$$$reportNull$$$0(1);
        }
        PsiElement prevSibling = sibling.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof PsiDeclarationStatement) {
            if (prevSibling.equals(variable.getParent())) {
                return null;
            }
            return ScopeUtils.findTighterDeclarationLocation(prevSibling, variable);
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement element) {
        if (ancestor == null) {
            ScopeUtils.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ScopeUtils.$$$reportNull$$$0(3);
        }
        PsiElement child = element;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    @Nullable
    public static PsiElement getCommonParent(@NotNull List<? extends PsiElement> referenceElements) {
        PsiElement parent;
        if (referenceElements == null) {
            ScopeUtils.$$$reportNull$$$0(4);
        }
        PsiElement commonParent = null;
        for (PsiElement psiElement : referenceElements) {
            PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class});
            if (parent2 != null && commonParent != null) {
                if (commonParent.equals(parent2)) continue;
                commonParent = PsiTreeUtil.findCommonParent((PsiElement)commonParent, (PsiElement)parent2);
                commonParent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)commonParent, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class});
                continue;
            }
            commonParent = parent2;
        }
        if (commonParent instanceof PsiTryStatement) {
            PsiElement referenceElement = referenceElements.get(0);
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiTryStatement)commonParent).getResourceList(), (PsiElement)referenceElement, (boolean)false)) {
                commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            }
        }
        if (commonParent instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)commonParent;
            PsiElement psiElement = referenceElements.get(0);
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiEmptyStatement)) {
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)initialization;
                    PsiExpression expression2 = statement.getExpression();
                    if (expression2 instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                        PsiExpression lExpression = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
                        if (!lExpression.equals(psiElement)) {
                            commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                        }
                    } else {
                        commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                    }
                } else {
                    commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                }
            }
        }
        if (commonParent != null && (parent = commonParent.getParent()) instanceof PsiSwitchStatement) {
            if (referenceElements.size() > 1) {
                return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)referenceElements.get(0), PsiSwitchLabelStatement.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class}) != null) {
                return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
            }
        }
        return commonParent;
    }

    @Nullable
    public static PsiElement moveOutOfLoopsAndClasses(@NotNull PsiElement scope, @NotNull PsiElement maxScope) {
        PsiElement result;
        if (scope == null) {
            ScopeUtils.$$$reportNull$$$0(5);
        }
        if (maxScope == null) {
            ScopeUtils.$$$reportNull$$$0(6);
        }
        if ((result = maxScope) instanceof PsiLoopStatement) {
            return result;
        }
        while (!result.equals(scope)) {
            PsiForStatement forStatement;
            PsiElement element = ScopeUtils.getChildWhichContainsElement(result, scope);
            if (element instanceof PsiForStatement && (forStatement = (PsiForStatement)element).getInitialization() instanceof PsiEmptyStatement) {
                return element;
            }
            if (element == null || element instanceof PsiLoopStatement || element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                while (result != null && !(result instanceof PsiCodeBlock)) {
                    result = result.getParent();
                }
                return result;
            }
            result = element;
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxScope";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/dataflow/ScopeUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTighterDeclarationLocation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildWhichContainsElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonParent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "moveOutOfLoopsAndClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

