/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PsiClassTypePattern
extends AopPsiTypePattern {
    private final String myText;
    private final Pattern myPattern;

    public PsiClassTypePattern(String pattern) {
        assert (!"*".equals(pattern));
        this.myText = pattern;
        String regex = "*".equals(pattern) ? ".*" : pattern.replaceAll("([\\[\\]\\^\\(\\)\\{\\}\\-])", "\\\\$1").replaceAll("\\*", "\\[\\^\\\\.]\\*").replaceAll("\\.", "\\\\.").replaceAll("\\\\.\\\\.", "\\(\\\\.\\|\\\\.\\.\\*\\\\.\\)");
        this.myPattern = Pattern.compile(regex);
    }

    public String getText() {
        return this.myText;
    }

    public String toString() {
        return "PsiClassTypePattern:" + this.myText;
    }

    @Override
    public boolean accepts(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiClassTypePattern.$$$reportNull$$$0(0);
        }
        return this.myPattern.matcher(qualifiedName).matches();
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        if (type == null) {
            PsiClassTypePattern.$$$reportNull$$$0(1);
        }
        if (type instanceof PsiClassType) {
            String qname = type.getCanonicalText();
            int generics = qname.indexOf(60);
            if (generics > 0) {
                qname = qname.substring(0, generics);
            }
            if (qname != null && this.accepts(qname)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/aop/psi/PsiClassTypePattern";
        objectArray[2] = "accepts";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

