/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructureBuilder
extends AbstractTestFileStructureBuilder<JasmineFileStructure> {
    private static final JasmineFileStructureBuilder INSTANCE = new JasmineFileStructureBuilder();
    public static final String DESCRIBE_NAME = "describe";
    public static final String CONTEXT_NAME = "context";
    public static final String DDESCRIBE_NAME = "ddescribe";
    public static final String XDESCRIBE_NAME = "xdescribe";
    public static final String FDESCRIBE_NAME = "fdescribe";
    public static final String IT_NAME = "it";
    public static final String TEST_NAME = "test";
    public static final String IIT_NAME = "iit";
    public static final String XIT_NAME = "xit";
    public static final String FIT_NAME = "fit";

    @Override
    @NotNull
    public JasmineFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(0);
        }
        JasmineFileStructure jasmineFileStructure = new Builder(jsFile).build();
        if (jasmineFileStructure == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(1);
        }
        return jasmineFileStructure;
    }

    public static JasmineFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestFileStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTestFileStructure";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builder {
        private final JasmineFileStructure myFileStructure;

        public Builder(JSFile jsFile) {
            this.myFileStructure = new JasmineFileStructure(jsFile);
        }

        public JasmineFileStructure build() {
            if (this.isJasmineFile()) {
                List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(this.myFileStructure.getJsFile());
                for (JSStatement statement : statements) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement(statement);
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(null, jsCallExpression);
                }
            }
            this.myFileStructure.postProcess();
            return this.myFileStructure;
        }

        private boolean isJasmineFile() {
            return JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.DESCRIBE_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.CONTEXT_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.IT_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.TEST_NAME, true);
        }

        private void handleCallExpr(@Nullable JasmineSuiteStructure parentSuiteStructure, @NotNull JSCallExpression callExpression) {
            JSExpression qualifier;
            if (callExpression == null) {
                Builder.$$$reportNull$$$0(0);
            }
            JSReferenceExpression methodExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
            JSReferenceExpression methodKeyExpr = null;
            if (methodExpr != null && (qualifier = methodExpr.getQualifier()) instanceof JSReferenceExpression) {
                methodKeyExpr = methodExpr;
                methodExpr = (JSReferenceExpression)qualifier;
            }
            JSArgumentList argumentList = callExpression.getArgumentList();
            if (methodExpr != null && methodExpr.getQualifier() == null && argumentList != null) {
                String name;
                JSExpression[] arguments = argumentList.getArguments();
                int argc = arguments.length;
                String methodName = methodExpr.getReferenceName();
                if (argc == 2 && Builder.isSuiteMethodName(methodName) && Builder.isSuiteMethodKeyName(methodKeyExpr)) {
                    name = JsPsiUtils.extractStringValue(arguments[0]);
                    JSFunctionExpression specDefinitions = JsPsiUtils.extractFunctionExpression(arguments[1]);
                    if (name != null && specDefinitions != null) {
                        JasmineSuiteStructure suiteStructure = new JasmineSuiteStructure(name, callExpression, specDefinitions, parentSuiteStructure);
                        if (parentSuiteStructure != null) {
                            parentSuiteStructure.addChild(suiteStructure);
                        } else {
                            this.myFileStructure.addSuiteStructure(suiteStructure);
                        }
                        this.handleSuite(suiteStructure, specDefinitions);
                    }
                }
                if ((argc == 2 || argc == 3) && Builder.isSpecMethodName(methodName) && (name = JsPsiUtils.extractStringValue(arguments[0])) != null) {
                    JasmineSpecStructure specStructure = new JasmineSpecStructure(name, callExpression, parentSuiteStructure);
                    if (parentSuiteStructure != null) {
                        parentSuiteStructure.addChild(specStructure);
                    } else {
                        this.myFileStructure.addSpecStructure(specStructure);
                    }
                }
            }
        }

        private static boolean isSuiteMethodName(@Nullable String methodName) {
            return JasmineFileStructureBuilder.DESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.CONTEXT_NAME.equals(methodName) || JasmineFileStructureBuilder.DDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.FDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.XDESCRIBE_NAME.equals(methodName);
        }

        private static boolean isSuiteMethodKeyName(@Nullable JSReferenceExpression methodKeyExpr) {
            if (methodKeyExpr != null) {
                String methodKeyName = methodKeyExpr.getReferenceName();
                return "skip".equals(methodKeyName) || "only".equals(methodKeyName);
            }
            return true;
        }

        private static boolean isSpecMethodName(String methodName) {
            return JasmineFileStructureBuilder.IT_NAME.equals(methodName) || JasmineFileStructureBuilder.TEST_NAME.equals(methodName) || JasmineFileStructureBuilder.IIT_NAME.equals(methodName) || JasmineFileStructureBuilder.FIT_NAME.equals(methodName) || JasmineFileStructureBuilder.XIT_NAME.equals(methodName);
        }

        private void handleSuite(@NotNull JasmineSuiteStructure suiteStructure, @NotNull JSFunctionExpression specDefinitions) {
            JSSourceElement[] sourceElements;
            if (suiteStructure == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (specDefinitions == null) {
                Builder.$$$reportNull$$$0(2);
            }
            for (JSSourceElement sourceElement : sourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)specDefinitions.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
                JSStatement[] statements;
                JSBlockStatement jsBlockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)sourceElement, JSBlockStatement.class);
                if (jsBlockStatement == null) continue;
                for (JSStatement statement : statements = (JSStatement[])ObjectUtils.notNull((Object)jsBlockStatement.getStatements(), (Object)JSStatement.EMPTY)) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement(statement);
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(suiteStructure, jsCallExpression);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteStructure";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "specDefinitions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleCallExpr";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleSuite";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

