/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;

public abstract class KtStubElementType<StubT extends StubElement, PsiT extends KtElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public KtStubElementType(@NotNull @NonNls String debugName, @NotNull Class<PsiT> psiClass, @NotNull Class<?> stubClass) {
        super(debugName, KotlinLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (KtElementImplStub[])Array.newInstance(psiClass, 0);
        this.arrayFactory = count2 -> {
            if (count2 == 0) {
                return this.emptyArray;
            }
            return (KtElementImplStub[])Array.newInstance(psiClass, count2);
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        return (PsiT)((KtElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, node));
    }

    @Override
    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        return (PsiT)((KtElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, stub));
    }

    @Override
    @NotNull
    public String getExternalId() {
        return "kotlin." + this.toString();
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof KtClassOrObject || psi instanceof KtFunction) {
            return true;
        }
        if (psi instanceof KtProperty) {
            return !((KtProperty)psi).isLocal();
        }
        return KtStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent2 = node.getTreeParent();
        IElementType parentType = parent2.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent2);
        }
        return parentType instanceof IStubFileElementType;
    }

    @Override
    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        return this.arrayFactory;
    }
}

