/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmTypeSpecificityComparator;", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "()V", "isDefinitelyLessSpecific", "", "specific", "Lorg/jetbrains/kotlin/types/KotlinType;", "general", "frontend.java"})
public final class JvmTypeSpecificityComparator
implements TypeSpecificityComparator {
    public static final JvmTypeSpecificityComparator INSTANCE;

    @Override
    public boolean isDefinitelyLessSpecific(@NotNull KotlinType specific, @NotNull KotlinType general) {
        Intrinsics.checkParameterIsNotNull(specific, "specific");
        Intrinsics.checkParameterIsNotNull(general, "general");
        if (!FlexibleTypesKt.isFlexible(specific) || FlexibleTypesKt.isFlexible(general)) {
            return false;
        }
        FlexibleType flexibility = FlexibleTypesKt.asFlexibleType(specific);
        if (!KotlinBuiltIns.isPrimitiveType(general) || !KotlinBuiltIns.isPrimitiveType(flexibility.getLowerBound())) {
            return false;
        }
        return !general.isMarkedNullable();
    }

    private JvmTypeSpecificityComparator() {
    }

    static {
        JvmTypeSpecificityComparator jvmTypeSpecificityComparator;
        INSTANCE = jvmTypeSpecificityComparator = new JvmTypeSpecificityComparator();
    }
}

