/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCapture
implements ConfigurableDurationData {
    public static final String MAIN_THREAD_NAME = "main";
    private final int myMainThreadId;
    @NotNull
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees;
    @NotNull
    private Range myRange;
    @NotNull
    private ClockType myClockType;

    public CpuCapture(@NotNull Range captureRange, @NotNull Map<CpuThreadInfo, CaptureNode> captureTrees) {
        if (captureRange == null) {
            CpuCapture.$$$reportNull$$$0(0);
        }
        if (captureTrees == null) {
            CpuCapture.$$$reportNull$$$0(1);
        }
        this.myRange = captureRange;
        this.myCaptureTrees = captureTrees;
        Map.Entry<CpuThreadInfo, CaptureNode> main = null;
        boolean foundMainThread = false;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : captureTrees.entrySet()) {
            if (entry.getKey().getName().equals(MAIN_THREAD_NAME)) {
                main = entry;
                foundMainThread = true;
            }
            if (foundMainThread || main != null && main.getValue().duration() >= entry.getValue().duration()) continue;
            main = entry;
        }
        assert (main != null);
        this.myMainThreadId = ((CpuThreadInfo)main.getKey()).getId();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @NotNull
    public Range getRange() {
        Range range = this.myRange;
        if (range == null) {
            CpuCapture.$$$reportNull$$$0(2);
        }
        return range;
    }

    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myCaptureTrees.entrySet()) {
            if (entry.getKey().getId() != threadId) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    Set<CpuThreadInfo> getThreads() {
        Set<CpuThreadInfo> set = this.myCaptureTrees.keySet();
        if (set == null) {
            CpuCapture.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean containsThread(int threadId) {
        return this.myCaptureTrees.keySet().stream().anyMatch(info -> info.getId() == threadId);
    }

    public long getDuration() {
        return (long)this.myRange.getLength();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public boolean canSelectPartialRange() {
        return true;
    }

    public void updateClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(4);
        }
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.myCaptureTrees.values()) {
            CpuCapture.updateClockType(tree, clockType);
        }
    }

    private static void updateClockType(@Nullable CaptureNode node, @NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(5);
        }
        if (node == null) {
            return;
        }
        node.setClockType(clockType);
        for (CaptureNode child : node.getChildren()) {
            CpuCapture.updateClockType(child, clockType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureTrees";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateClockType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

