/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RpcNetworkConnectionsModel
implements NetworkConnectionsModel {
    @NotNull
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerService;
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    private final int myPid;
    private final Common.Session mySession;

    public RpcNetworkConnectionsModel(@NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, int pid, Common.Session session) {
        if (profilerService == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(0);
        }
        if (networkService == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(1);
        }
        this.myProfilerService = profilerService;
        this.myNetworkService = networkService;
        this.myPid = pid;
        this.mySession = session;
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(2);
        }
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setProcessId(this.myPid).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        NetworkProfiler.HttpRangeResponse response = this.myNetworkService.getHttpRange(request);
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp());
            long downloadTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp());
            HttpData.Builder httpBuilder = new HttpData.Builder(connection.getConnId(), startTimeUs, endTimeUs, downloadTimeUs);
            this.requestHttpRequest(connection.getConnId(), httpBuilder);
            this.requestAccessingThreads(connection.getConnId(), httpBuilder);
            if (connection.getEndTimestamp() != 0L) {
                this.requestHttpResponse(connection.getConnId(), httpBuilder);
                this.requestHttpResponseBody(connection.getConnId(), httpBuilder);
            }
            httpDataList.add(httpBuilder.build());
        }
        ArrayList<HttpData> arrayList = httpDataList;
        if (arrayList == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpRequest(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(4);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.REQUEST).build();
        NetworkProfiler.HttpDetailsResponse.Request result = this.myNetworkService.getHttpDetails(request).getRequest();
        httpBuilder.setUrl(result.getUrl());
        httpBuilder.setMethod(result.getMethod());
        httpBuilder.setTrace(result.getTrace());
        httpBuilder.setRequestFields(result.getFields());
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpResponseBody(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(5);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        String payloadId = response.getResponseBody().getPayloadId();
        httpBuilder.setResponsePayloadId(payloadId);
    }

    @Override
    @NotNull
    public ByteString requestResponsePayload(@NotNull HttpData data) {
        if (data == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)data.getResponsePayloadId())) {
            ByteString byteString = ByteString.EMPTY;
            if (byteString == null) {
                RpcNetworkConnectionsModel.$$$reportNull$$$0(7);
            }
            return byteString;
        }
        Profiler.BytesRequest request = Profiler.BytesRequest.newBuilder().setId(data.getResponsePayloadId()).setSession(this.mySession).build();
        Profiler.BytesResponse response = this.myProfilerService.getBytes(request);
        ByteString byteString = response.getContents();
        if (byteString == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(8);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private void requestHttpResponse(long connectionId, @NotNull HttpData.Builder builder) {
        void httpBuilder;
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(9);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        httpBuilder.setResponseFields(response.getResponse().getFields());
    }

    /*
     * WARNING - void declaration
     */
    private void requestAccessingThreads(long connectionId, @NotNull HttpData.Builder builder) {
        if (builder == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(10);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS).build();
        NetworkProfiler.HttpDetailsResponse response = this.myNetworkService.getHttpDetails(request);
        for (NetworkProfiler.JavaThread thread : response.getAccessingThreads().getThreadList()) {
            void httpBuilder;
            httpBuilder.addJavaThread(new HttpData.JavaThread(thread.getId(), thread.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "networkService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "requestResponsePayload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpResponseBody";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestResponsePayload";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpResponse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestAccessingThreads";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

