/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeLocation {
    public static final int INVALID_LINE_NUMBER = -1;
    @NotNull
    private final String myClassName;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myMethodName;
    @Nullable
    private final String mySignature;
    private final int myLineNumber;
    private final int myHashcode;

    private CodeLocation(@NotNull Builder builder) {
        if (builder == null) {
            CodeLocation.$$$reportNull$$$0(0);
        }
        this.myClassName = builder.myClassName;
        this.myFileName = builder.myFileName;
        this.myMethodName = builder.myMethodName;
        this.mySignature = builder.mySignature;
        this.myLineNumber = builder.myLineNumber;
        this.myHashcode = Arrays.hashCode(new int[]{this.myClassName.hashCode(), this.myFileName == null ? 0 : this.myFileName.hashCode(), this.myMethodName == null ? 0 : this.myMethodName.hashCode(), this.mySignature == null ? 0 : this.mySignature.hashCode(), Integer.hashCode(this.myLineNumber)});
    }

    @NotNull
    public static CodeLocation stub() {
        CodeLocation codeLocation = new Builder("").build();
        if (codeLocation == null) {
            CodeLocation.$$$reportNull$$$0(1);
        }
        return codeLocation;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            CodeLocation.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getOuterClassName() {
        int innerCharIndex = this.myClassName.indexOf(36);
        if (innerCharIndex < 0) {
            innerCharIndex = this.myClassName.length();
        }
        String string = this.myClassName.substring(0, innerCharIndex);
        if (string == null) {
            CodeLocation.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    public int hashCode() {
        return this.myHashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeLocation)) {
            return false;
        }
        CodeLocation other = (CodeLocation)obj;
        return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myFileName, (CharSequence)other.myFileName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName) && StringUtil.equals((CharSequence)this.mySignature, (CharSequence)other.mySignature) && this.myLineNumber == other.myLineNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/stacktrace/CodeLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/stacktrace/CodeLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stub";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        @NotNull
        private final String myClassName;
        @Nullable
        String myFileName;
        @Nullable
        String myMethodName;
        @Nullable
        String mySignature;
        int myLineNumber;

        public Builder(@NotNull String className) {
            if (className == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myLineNumber = -1;
            this.myClassName = className;
        }

        public Builder(@NotNull CodeLocation rhs) {
            if (rhs == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myLineNumber = -1;
            this.myClassName = rhs.getClassName();
            this.myFileName = rhs.getFileName();
            this.myMethodName = rhs.getMethodName();
            this.mySignature = rhs.getSignature();
            this.myLineNumber = rhs.getLineNumber();
        }

        @NotNull
        public Builder setFileName(@Nullable String fileName) {
            this.myFileName = StringUtil.nullize((String)fileName);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setMethodName(@Nullable String methodName) {
            this.myMethodName = StringUtil.nullize((String)methodName);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setMethodSignature(@NotNull String methodName, @NotNull String signature) {
            if (methodName == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (signature == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myMethodName = methodName;
            this.mySignature = signature;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setLineNumber(int lineNumber) {
            this.myLineNumber = lineNumber;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public CodeLocation build() {
            CodeLocation codeLocation = new CodeLocation(this);
            if (codeLocation == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return codeLocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rhs";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/stacktrace/CodeLocation$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/stacktrace/CodeLocation$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFileName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethodName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethodSignature";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLineNumber";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setMethodSignature";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

