/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringManager {
    private static final NotNullLazyKey<SpringManager, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(SpringManager.class);

    public static SpringManager getInstance(Project project) {
        return (SpringManager)INSTANCE_CACHE.getValue((UserDataHolder)project);
    }

    @NotNull
    public abstract Object[] getModelsDependencies(@NotNull Module var1, Object ... var2);

    @NotNull
    public abstract Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile var1);

    @Nullable
    public abstract SpringModel getSpringModelByFile(@NotNull PsiFile var1);

    @Deprecated
    @Nullable
    public abstract LocalXmlModel getLocalSpringModel(@NotNull XmlFile var1);

    @Deprecated
    @Nullable
    public abstract LocalXmlModel getLocalSpringModel(@NotNull XmlFile var1, @NotNull Module var2);

    @Deprecated
    @Nullable
    public abstract LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass var1);

    @Deprecated
    @Nullable
    public abstract LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass var1, @NotNull Module var2);

    @NotNull
    public abstract Set<SpringModel> getAllModels(@NotNull Module var1);

    public abstract Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module var1);

    @NotNull
    public abstract SpringModel getCombinedModel(@NotNull Module var1);
}

