/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentScanPackagesModel
extends AbstractSimpleSpringModel {
    private final NotNullLazyValue<Set<PsiPackage>> myPackages;
    @NotNull
    private final Module myModule;

    public ComponentScanPackagesModel(@NotNull NotNullLazyValue<Set<PsiPackage>> packages, @NotNull Module module) {
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(1);
        }
        this.myPackages = packages;
        this.myModule = module;
    }

    @Override
    protected final Collection<SpringBeanPointer> calculateLocalBeans() {
        Collection<SpringBeanPointer> pointers = this.calculateScannedBeans();
        LinkedHashSet javaBeans = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : pointers) {
            Object springBean = pointer.getSpringBean();
            if (springBean instanceof SpringConfiguration || !(springBean instanceof SpringStereotypeElement)) continue;
            javaBeans.addAll(((SpringStereotypeElement)springBean).getBeans());
        }
        LinkedHashSet beans = ContainerUtil.newLinkedHashSet();
        beans.addAll(pointers);
        beans.addAll(BeanService.getInstance().mapSpringBeans(javaBeans));
        return beans;
    }

    @Override
    @NotNull
    public Collection<SpringBeanPointer> calculateDomBeans() {
        Set<SpringBeanPointer> set = Collections.emptySet();
        if (set == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    protected Collection<SpringBeanPointer> calculateScannedBeans() {
        return ComponentScanPackagesModel.getScannedComponents((Set)this.myPackages.getValue(), this.getModule(), this.getActiveProfiles());
    }

    public static Collection<SpringBeanPointer> getScannedComponents(@NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles) {
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(4);
        }
        return ComponentScanPackagesModel.getScannedComponents(packages, module, profiles, true, Collections.emptySet(), Collections.emptySet());
    }

    public static Collection<SpringConfiguration> getScannedConfigurations(SpringBeansPackagesScan scan, @NotNull Module module, @Nullable Set<String> profiles) {
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(5);
        }
        List<CommonSpringBean> components = ComponentScanPackagesModel.getScannedComponents(dom -> {
            if (module == null) {
                ComponentScanPackagesModel.$$$reportNull$$$0(20);
            }
            return SpringJamModel.getModel(module).getConfigurations((GlobalSearchScope)dom);
        }, scan.getPsiPackages(), module, profiles, scan.useDefaultFilters(), scan.getExcludeContextFilters(), scan.getIncludeContextFilters());
        LinkedHashSet<SpringConfiguration> configurations = new LinkedHashSet<SpringConfiguration>();
        for (CommonSpringBean component : components) {
            if (!(component instanceof SpringConfiguration)) continue;
            configurations.add((SpringConfiguration)component);
        }
        return configurations;
    }

    public static Collection<SpringBeanPointer> getScannedComponents(@NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(7);
        }
        if (excludeContextFilters == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(8);
        }
        if (includeContextFilters == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(9);
        }
        List<CommonSpringBean> components = ComponentScanPackagesModel.getScannedComponents(scope -> {
            if (module == null) {
                ComponentScanPackagesModel.$$$reportNull$$$0(19);
            }
            return SpringJamModel.getModel(module).getStereotypeComponents((GlobalSearchScope)scope);
        }, packages, module, profiles, useDefaultFilters, excludeContextFilters, includeContextFilters);
        return BeanService.getInstance().mapSpringBeans(components);
    }

    public static <T extends SpringStereotypeElement> List<CommonSpringBean> getScannedComponents(@NotNull NotNullFunction<GlobalSearchScope, List<T>> components, @NotNull Set<PsiPackage> packages, @NotNull Module module, @Nullable Set<String> profiles, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (components == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(10);
        }
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(11);
        }
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(12);
        }
        if (excludeContextFilters == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(13);
        }
        if (includeContextFilters == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(14);
        }
        if (module.isDisposed() || packages.isEmpty()) {
            return ContainerUtil.newSmartList();
        }
        GlobalSearchScope allPackagesUnionScope = null;
        for (PsiPackage psiPackage : packages) {
            if (psiPackage.getQualifiedName().isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalArgumentException("Do not use component-scan with <default> package in tests");
            }
            GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true);
            allPackagesUnionScope = allPackagesUnionScope == null ? packageScope : allPackagesUnionScope.uniteWith(packageScope);
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        GlobalSearchScope effectiveSearchScope = moduleScope.intersectWith(allPackagesUnionScope);
        List allPointers = (List)components.fun((Object)effectiveSearchScope);
        Set<CommonSpringBean> filteredBeans = SpringJamUtils.getInstance().filterComponentScannedStereotypes(module, allPointers, packages, useDefaultFilters, excludeContextFilters, includeContextFilters);
        return SpringProfileUtils.filterBeansInActiveProfiles(filteredBeans, profiles);
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(15);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getAllProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<PsiFile> set = Collections.emptySet();
        if (set == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Override
    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(18);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/ComponentScanPackagesModel";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeContextFilters";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeContextFilters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/ComponentScanPackagesModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDomBeans";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getScannedComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScannedConfigurations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScannedComponents$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScannedConfigurations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

